package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  SubnetId,
  SensitiveUserData,
  KeyPairName,
  SecurityGroupId,
  KernelId,
  ImageId,
  RamdiskId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RequestSpotLaunchSpecification(
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    securityGroups: Optional[Iterable[String]] = Optional.Absent,
    addressingType: Optional[String] = Optional.Absent,
    blockDeviceMappings: Optional[
      Iterable[zio.aws.ec2.model.BlockDeviceMapping]
    ] = Optional.Absent,
    ebsOptimized: Optional[Boolean] = Optional.Absent,
    iamInstanceProfile: Optional[
      zio.aws.ec2.model.IamInstanceProfileSpecification
    ] = Optional.Absent,
    imageId: Optional[ImageId] = Optional.Absent,
    instanceType: Optional[zio.aws.ec2.model.InstanceType] = Optional.Absent,
    kernelId: Optional[KernelId] = Optional.Absent,
    keyName: Optional[KeyPairName] = Optional.Absent,
    monitoring: Optional[zio.aws.ec2.model.RunInstancesMonitoringEnabled] =
      Optional.Absent,
    networkInterfaces: Optional[
      Iterable[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification]
    ] = Optional.Absent,
    placement: Optional[zio.aws.ec2.model.SpotPlacement] = Optional.Absent,
    ramdiskId: Optional[RamdiskId] = Optional.Absent,
    subnetId: Optional[SubnetId] = Optional.Absent,
    userData: Optional[SensitiveUserData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RequestSpotLaunchSpecification = {
    import RequestSpotLaunchSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RequestSpotLaunchSpecification
      .builder()
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(addressingType.map(value => value: java.lang.String))(
        _.addressingType
      )
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(ebsOptimized.map(value => value: java.lang.Boolean))(
        _.ebsOptimized
      )
      .optionallyWith(iamInstanceProfile.map(value => value.buildAwsValue()))(
        _.iamInstanceProfile
      )
      .optionallyWith(
        imageId.map(value => ImageId.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(
        kernelId.map(value => KernelId.unwrap(value): java.lang.String)
      )(_.kernelId)
      .optionallyWith(
        keyName.map(value => KeyPairName.unwrap(value): java.lang.String)
      )(_.keyName)
      .optionallyWith(monitoring.map(value => value.buildAwsValue()))(
        _.monitoring
      )
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(placement.map(value => value.buildAwsValue()))(
        _.placement
      )
      .optionallyWith(
        ramdiskId.map(value => RamdiskId.unwrap(value): java.lang.String)
      )(_.ramdiskId)
      .optionallyWith(
        subnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        userData.map(value => SensitiveUserData.unwrap(value): java.lang.String)
      )(_.userData)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.RequestSpotLaunchSpecification.ReadOnly =
    zio.aws.ec2.model.RequestSpotLaunchSpecification.wrap(buildAwsValue())
}
object RequestSpotLaunchSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RequestSpotLaunchSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.RequestSpotLaunchSpecification =
      zio.aws.ec2.model.RequestSpotLaunchSpecification(
        securityGroupIds.map(value => value),
        securityGroups.map(value => value),
        addressingType.map(value => value),
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ebsOptimized.map(value => value),
        iamInstanceProfile.map(value => value.asEditable),
        imageId.map(value => value),
        instanceType.map(value => value),
        kernelId.map(value => value),
        keyName.map(value => value),
        monitoring.map(value => value.asEditable),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placement.map(value => value.asEditable),
        ramdiskId.map(value => value),
        subnetId.map(value => value),
        userData.map(value => value)
      )
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def securityGroups: Optional[List[String]]
    def addressingType: Optional[String]
    def blockDeviceMappings
        : Optional[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]]
    def ebsOptimized: Optional[Boolean]
    def iamInstanceProfile
        : Optional[zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly]
    def imageId: Optional[ImageId]
    def instanceType: Optional[zio.aws.ec2.model.InstanceType]
    def kernelId: Optional[KernelId]
    def keyName: Optional[KeyPairName]
    def monitoring
        : Optional[zio.aws.ec2.model.RunInstancesMonitoringEnabled.ReadOnly]
    def networkInterfaces: Optional[
      List[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly]
    ]
    def placement: Optional[zio.aws.ec2.model.SpotPlacement.ReadOnly]
    def ramdiskId: Optional[RamdiskId]
    def subnetId: Optional[SubnetId]
    def userData: Optional[SensitiveUserData]
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getAddressingType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("addressingType", addressingType)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.BlockDeviceMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getEbsOptimized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getIamInstanceProfile: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly
    ] = AwsError.unwrapOptionField("iamInstanceProfile", iamInstanceProfile)
    def getImageId: ZIO[Any, AwsError, ImageId] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKernelId: ZIO[Any, AwsError, KernelId] =
      AwsError.unwrapOptionField("kernelId", kernelId)
    def getKeyName: ZIO[Any, AwsError, KeyPairName] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getMonitoring: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.RunInstancesMonitoringEnabled.ReadOnly
    ] = AwsError.unwrapOptionField("monitoring", monitoring)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getPlacement
        : ZIO[Any, AwsError, zio.aws.ec2.model.SpotPlacement.ReadOnly] =
      AwsError.unwrapOptionField("placement", placement)
    def getRamdiskId: ZIO[Any, AwsError, RamdiskId] =
      AwsError.unwrapOptionField("ramdiskId", ramdiskId)
    def getSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getUserData: ZIO[Any, AwsError, SensitiveUserData] =
      AwsError.unwrapOptionField("userData", userData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RequestSpotLaunchSpecification
  ) extends zio.aws.ec2.model.RequestSpotLaunchSpecification.ReadOnly {
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val securityGroups: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.securityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val addressingType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.addressingType())
      .map(value => value: String)
    override val blockDeviceMappings
        : Optional[List[zio.aws.ec2.model.BlockDeviceMapping.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blockDeviceMappings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.BlockDeviceMapping.wrap(item)
          }.toList
        )
    override val ebsOptimized: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsOptimized())
      .map(value => value: Boolean)
    override val iamInstanceProfile
        : Optional[zio.aws.ec2.model.IamInstanceProfileSpecification.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamInstanceProfile())
        .map(value =>
          zio.aws.ec2.model.IamInstanceProfileSpecification.wrap(value)
        )
    override val imageId: Optional[ImageId] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.ec2.model.primitives.ImageId(value))
    override val instanceType: Optional[zio.aws.ec2.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val kernelId: Optional[KernelId] = zio.aws.core.internal
      .optionalFromNullable(impl.kernelId())
      .map(value => zio.aws.ec2.model.primitives.KernelId(value))
    override val keyName: Optional[KeyPairName] = zio.aws.core.internal
      .optionalFromNullable(impl.keyName())
      .map(value => zio.aws.ec2.model.primitives.KeyPairName(value))
    override val monitoring
        : Optional[zio.aws.ec2.model.RunInstancesMonitoringEnabled.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoring())
        .map(value =>
          zio.aws.ec2.model.RunInstancesMonitoringEnabled.wrap(value)
        )
    override val networkInterfaces: Optional[
      List[zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceNetworkInterfaceSpecification.wrap(item)
        }.toList
      )
    override val placement: Optional[zio.aws.ec2.model.SpotPlacement.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placement())
        .map(value => zio.aws.ec2.model.SpotPlacement.wrap(value))
    override val ramdiskId: Optional[RamdiskId] = zio.aws.core.internal
      .optionalFromNullable(impl.ramdiskId())
      .map(value => zio.aws.ec2.model.primitives.RamdiskId(value))
    override val subnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.ec2.model.primitives.SubnetId(value))
    override val userData: Optional[SensitiveUserData] = zio.aws.core.internal
      .optionalFromNullable(impl.userData())
      .map(value => zio.aws.ec2.model.primitives.SensitiveUserData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RequestSpotLaunchSpecification
  ): zio.aws.ec2.model.RequestSpotLaunchSpecification.ReadOnly = new Wrapper(
    impl
  )
}
