package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait PrefixListState {
  def unwrap: software.amazon.awssdk.services.ec2.model.PrefixListState
}
object PrefixListState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.PrefixListState
  ): zio.aws.ec2.model.PrefixListState = value match {
    case software.amazon.awssdk.services.ec2.model.PrefixListState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.PrefixListState.CREATE_IN_PROGRESS =>
      val r = `create-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.PrefixListState.CREATE_COMPLETE =>
      val r = `create-complete`
      r
    case software.amazon.awssdk.services.ec2.model.PrefixListState.CREATE_FAILED =>
      val r = `create-failed`
      r
    case software.amazon.awssdk.services.ec2.model.PrefixListState.MODIFY_IN_PROGRESS =>
      val r = `modify-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.PrefixListState.MODIFY_COMPLETE =>
      val r = `modify-complete`
      r
    case software.amazon.awssdk.services.ec2.model.PrefixListState.MODIFY_FAILED =>
      val r = `modify-failed`
      r
    case software.amazon.awssdk.services.ec2.model.PrefixListState.RESTORE_IN_PROGRESS =>
      val r = `restore-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.PrefixListState.RESTORE_COMPLETE =>
      val r = `restore-complete`
      r
    case software.amazon.awssdk.services.ec2.model.PrefixListState.RESTORE_FAILED =>
      val r = `restore-failed`
      r
    case software.amazon.awssdk.services.ec2.model.PrefixListState.DELETE_IN_PROGRESS =>
      val r = `delete-in-progress`
      r
    case software.amazon.awssdk.services.ec2.model.PrefixListState.DELETE_COMPLETE =>
      val r = `delete-complete`
      r
    case software.amazon.awssdk.services.ec2.model.PrefixListState.DELETE_FAILED =>
      val r = `delete-failed`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.PrefixListState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PrefixListState =
      software.amazon.awssdk.services.ec2.model.PrefixListState.UNKNOWN_TO_SDK_VERSION
  }
  case object `create-in-progress` extends zio.aws.ec2.model.PrefixListState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PrefixListState =
      software.amazon.awssdk.services.ec2.model.PrefixListState.CREATE_IN_PROGRESS
  }
  case object `create-complete` extends zio.aws.ec2.model.PrefixListState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PrefixListState =
      software.amazon.awssdk.services.ec2.model.PrefixListState.CREATE_COMPLETE
  }
  case object `create-failed` extends zio.aws.ec2.model.PrefixListState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PrefixListState =
      software.amazon.awssdk.services.ec2.model.PrefixListState.CREATE_FAILED
  }
  case object `modify-in-progress` extends zio.aws.ec2.model.PrefixListState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PrefixListState =
      software.amazon.awssdk.services.ec2.model.PrefixListState.MODIFY_IN_PROGRESS
  }
  case object `modify-complete` extends zio.aws.ec2.model.PrefixListState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PrefixListState =
      software.amazon.awssdk.services.ec2.model.PrefixListState.MODIFY_COMPLETE
  }
  case object `modify-failed` extends zio.aws.ec2.model.PrefixListState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PrefixListState =
      software.amazon.awssdk.services.ec2.model.PrefixListState.MODIFY_FAILED
  }
  case object `restore-in-progress` extends zio.aws.ec2.model.PrefixListState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PrefixListState =
      software.amazon.awssdk.services.ec2.model.PrefixListState.RESTORE_IN_PROGRESS
  }
  case object `restore-complete` extends zio.aws.ec2.model.PrefixListState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PrefixListState =
      software.amazon.awssdk.services.ec2.model.PrefixListState.RESTORE_COMPLETE
  }
  case object `restore-failed` extends zio.aws.ec2.model.PrefixListState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PrefixListState =
      software.amazon.awssdk.services.ec2.model.PrefixListState.RESTORE_FAILED
  }
  case object `delete-in-progress` extends zio.aws.ec2.model.PrefixListState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PrefixListState =
      software.amazon.awssdk.services.ec2.model.PrefixListState.DELETE_IN_PROGRESS
  }
  case object `delete-complete` extends zio.aws.ec2.model.PrefixListState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PrefixListState =
      software.amazon.awssdk.services.ec2.model.PrefixListState.DELETE_COMPLETE
  }
  case object `delete-failed` extends zio.aws.ec2.model.PrefixListState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.PrefixListState =
      software.amazon.awssdk.services.ec2.model.PrefixListState.DELETE_FAILED
  }
}
