package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait PeriodType {
  def unwrap: software.amazon.awssdk.services.ec2.model.PeriodType
}
object PeriodType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.PeriodType
  ): zio.aws.ec2.model.PeriodType = value match {
    case software.amazon.awssdk.services.ec2.model.PeriodType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.PeriodType.FIVE_MINUTES =>
      val r = `five-minutes`
      r
    case software.amazon.awssdk.services.ec2.model.PeriodType.FIFTEEN_MINUTES =>
      val r = `fifteen-minutes`
      r
    case software.amazon.awssdk.services.ec2.model.PeriodType.ONE_HOUR =>
      val r = `one-hour`
      r
    case software.amazon.awssdk.services.ec2.model.PeriodType.THREE_HOURS =>
      val r = `three-hours`
      r
    case software.amazon.awssdk.services.ec2.model.PeriodType.ONE_DAY =>
      val r = `one-day`
      r
    case software.amazon.awssdk.services.ec2.model.PeriodType.ONE_WEEK =>
      val r = `one-week`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.PeriodType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.PeriodType =
      software.amazon.awssdk.services.ec2.model.PeriodType.UNKNOWN_TO_SDK_VERSION
  }
  case object `five-minutes` extends zio.aws.ec2.model.PeriodType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.PeriodType =
      software.amazon.awssdk.services.ec2.model.PeriodType.FIVE_MINUTES
  }
  case object `fifteen-minutes` extends zio.aws.ec2.model.PeriodType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.PeriodType =
      software.amazon.awssdk.services.ec2.model.PeriodType.FIFTEEN_MINUTES
  }
  case object `one-hour` extends zio.aws.ec2.model.PeriodType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.PeriodType =
      software.amazon.awssdk.services.ec2.model.PeriodType.ONE_HOUR
  }
  case object `three-hours` extends zio.aws.ec2.model.PeriodType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.PeriodType =
      software.amazon.awssdk.services.ec2.model.PeriodType.THREE_HOURS
  }
  case object `one-day` extends zio.aws.ec2.model.PeriodType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.PeriodType =
      software.amazon.awssdk.services.ec2.model.PeriodType.ONE_DAY
  }
  case object `one-week` extends zio.aws.ec2.model.PeriodType {
    override def unwrap: software.amazon.awssdk.services.ec2.model.PeriodType =
      software.amazon.awssdk.services.ec2.model.PeriodType.ONE_WEEK
  }
}
