package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  MillisecondDateTime,
  Integer,
  IpAddress,
  NetworkInsightsPathId,
  ResourceArn
}
import scala.jdk.CollectionConverters._
final case class NetworkInsightsPath(
    networkInsightsPathId: Optional[NetworkInsightsPathId] = Optional.Absent,
    networkInsightsPathArn: Optional[ResourceArn] = Optional.Absent,
    createdDate: Optional[MillisecondDateTime] = Optional.Absent,
    source: Optional[String] = Optional.Absent,
    destination: Optional[String] = Optional.Absent,
    sourceArn: Optional[ResourceArn] = Optional.Absent,
    destinationArn: Optional[ResourceArn] = Optional.Absent,
    sourceIp: Optional[IpAddress] = Optional.Absent,
    destinationIp: Optional[IpAddress] = Optional.Absent,
    protocol: Optional[zio.aws.ec2.model.Protocol] = Optional.Absent,
    destinationPort: Optional[Integer] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    filterAtSource: Optional[zio.aws.ec2.model.PathFilter] = Optional.Absent,
    filterAtDestination: Optional[zio.aws.ec2.model.PathFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkInsightsPath = {
    import NetworkInsightsPath.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInsightsPath
      .builder()
      .optionallyWith(
        networkInsightsPathId.map(value =>
          NetworkInsightsPathId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsPathId)
      .optionallyWith(
        networkInsightsPathArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.networkInsightsPathArn)
      .optionallyWith(
        createdDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(destination.map(value => value: java.lang.String))(
        _.destination
      )
      .optionallyWith(
        sourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.sourceArn)
      .optionallyWith(
        destinationArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.destinationArn)
      .optionallyWith(
        sourceIp.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.sourceIp)
      .optionallyWith(
        destinationIp.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.destinationIp)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(destinationPort.map(value => value: java.lang.Integer))(
        _.destinationPort
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(filterAtSource.map(value => value.buildAwsValue()))(
        _.filterAtSource
      )
      .optionallyWith(filterAtDestination.map(value => value.buildAwsValue()))(
        _.filterAtDestination
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkInsightsPath.ReadOnly =
    zio.aws.ec2.model.NetworkInsightsPath.wrap(buildAwsValue())
}
object NetworkInsightsPath {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkInsightsPath
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInsightsPath =
      zio.aws.ec2.model.NetworkInsightsPath(
        networkInsightsPathId.map(value => value),
        networkInsightsPathArn.map(value => value),
        createdDate.map(value => value),
        source.map(value => value),
        destination.map(value => value),
        sourceArn.map(value => value),
        destinationArn.map(value => value),
        sourceIp.map(value => value),
        destinationIp.map(value => value),
        protocol.map(value => value),
        destinationPort.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        filterAtSource.map(value => value.asEditable),
        filterAtDestination.map(value => value.asEditable)
      )
    def networkInsightsPathId: Optional[NetworkInsightsPathId]
    def networkInsightsPathArn: Optional[ResourceArn]
    def createdDate: Optional[MillisecondDateTime]
    def source: Optional[String]
    def destination: Optional[String]
    def sourceArn: Optional[ResourceArn]
    def destinationArn: Optional[ResourceArn]
    def sourceIp: Optional[IpAddress]
    def destinationIp: Optional[IpAddress]
    def protocol: Optional[zio.aws.ec2.model.Protocol]
    def destinationPort: Optional[Integer]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def filterAtSource: Optional[zio.aws.ec2.model.PathFilter.ReadOnly]
    def filterAtDestination: Optional[zio.aws.ec2.model.PathFilter.ReadOnly]
    def getNetworkInsightsPathId: ZIO[Any, AwsError, NetworkInsightsPathId] =
      AwsError.unwrapOptionField("networkInsightsPathId", networkInsightsPathId)
    def getNetworkInsightsPathArn: ZIO[Any, AwsError, ResourceArn] = AwsError
      .unwrapOptionField("networkInsightsPathArn", networkInsightsPathArn)
    def getCreatedDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getDestination: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destination", destination)
    def getSourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getDestinationArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
    def getSourceIp: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("sourceIp", sourceIp)
    def getDestinationIp: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("destinationIp", destinationIp)
    def getProtocol: ZIO[Any, AwsError, zio.aws.ec2.model.Protocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getDestinationPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("destinationPort", destinationPort)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getFilterAtSource
        : ZIO[Any, AwsError, zio.aws.ec2.model.PathFilter.ReadOnly] =
      AwsError.unwrapOptionField("filterAtSource", filterAtSource)
    def getFilterAtDestination
        : ZIO[Any, AwsError, zio.aws.ec2.model.PathFilter.ReadOnly] =
      AwsError.unwrapOptionField("filterAtDestination", filterAtDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInsightsPath
  ) extends zio.aws.ec2.model.NetworkInsightsPath.ReadOnly {
    override val networkInsightsPathId: Optional[NetworkInsightsPathId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInsightsPathId())
        .map(value => zio.aws.ec2.model.primitives.NetworkInsightsPathId(value))
    override val networkInsightsPathArn: Optional[ResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInsightsPathArn())
        .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val createdDate: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdDate())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val source: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => value: String)
    override val destination: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destination())
      .map(value => value: String)
    override val sourceArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val destinationArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val sourceIp: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceIp())
      .map(value => zio.aws.ec2.model.primitives.IpAddress(value))
    override val destinationIp: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationIp())
      .map(value => zio.aws.ec2.model.primitives.IpAddress(value))
    override val protocol: Optional[zio.aws.ec2.model.Protocol] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value => zio.aws.ec2.model.Protocol.wrap(value))
    override val destinationPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationPort())
      .map(value => value: Integer)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val filterAtSource
        : Optional[zio.aws.ec2.model.PathFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterAtSource())
        .map(value => zio.aws.ec2.model.PathFilter.wrap(value))
    override val filterAtDestination
        : Optional[zio.aws.ec2.model.PathFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterAtDestination())
        .map(value => zio.aws.ec2.model.PathFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInsightsPath
  ): zio.aws.ec2.model.NetworkInsightsPath.ReadOnly = new Wrapper(impl)
}
