package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.AllocationId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnableAddressTransferRequest(
    allocationId: AllocationId,
    transferAccountId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.EnableAddressTransferRequest = {
    import EnableAddressTransferRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.EnableAddressTransferRequest
      .builder()
      .allocationId(AllocationId.unwrap(allocationId): java.lang.String)
      .transferAccountId(transferAccountId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.EnableAddressTransferRequest.ReadOnly =
    zio.aws.ec2.model.EnableAddressTransferRequest.wrap(buildAwsValue())
}
object EnableAddressTransferRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.EnableAddressTransferRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.EnableAddressTransferRequest =
      zio.aws.ec2.model
        .EnableAddressTransferRequest(allocationId, transferAccountId)
    def allocationId: AllocationId
    def transferAccountId: String
    def getAllocationId: ZIO[Any, Nothing, AllocationId] =
      ZIO.succeed(allocationId)
    def getTransferAccountId: ZIO[Any, Nothing, String] =
      ZIO.succeed(transferAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.EnableAddressTransferRequest
  ) extends zio.aws.ec2.model.EnableAddressTransferRequest.ReadOnly {
    override val allocationId: AllocationId =
      zio.aws.ec2.model.primitives.AllocationId(impl.allocationId())
    override val transferAccountId: String = impl.transferAccountId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.EnableAddressTransferRequest
  ): zio.aws.ec2.model.EnableAddressTransferRequest.ReadOnly = new Wrapper(impl)
}
