package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait DnsRecordIpType {
  def unwrap: software.amazon.awssdk.services.ec2.model.DnsRecordIpType
}
object DnsRecordIpType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.DnsRecordIpType
  ): zio.aws.ec2.model.DnsRecordIpType = value match {
    case software.amazon.awssdk.services.ec2.model.DnsRecordIpType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.DnsRecordIpType.IPV4 =>
      val r = ipv4
      r
    case software.amazon.awssdk.services.ec2.model.DnsRecordIpType.DUALSTACK =>
      val r = dualstack
      r
    case software.amazon.awssdk.services.ec2.model.DnsRecordIpType.IPV6 =>
      val r = ipv6
      r
    case software.amazon.awssdk.services.ec2.model.DnsRecordIpType.SERVICE_DEFINED =>
      val r = `service-defined`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.DnsRecordIpType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DnsRecordIpType =
      software.amazon.awssdk.services.ec2.model.DnsRecordIpType.UNKNOWN_TO_SDK_VERSION
  }
  case object ipv4 extends zio.aws.ec2.model.DnsRecordIpType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DnsRecordIpType =
      software.amazon.awssdk.services.ec2.model.DnsRecordIpType.IPV4
  }
  case object dualstack extends zio.aws.ec2.model.DnsRecordIpType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DnsRecordIpType =
      software.amazon.awssdk.services.ec2.model.DnsRecordIpType.DUALSTACK
  }
  case object ipv6 extends zio.aws.ec2.model.DnsRecordIpType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DnsRecordIpType =
      software.amazon.awssdk.services.ec2.model.DnsRecordIpType.IPV6
  }
  case object `service-defined` extends zio.aws.ec2.model.DnsRecordIpType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.DnsRecordIpType =
      software.amazon.awssdk.services.ec2.model.DnsRecordIpType.SERVICE_DEFINED
  }
}
