package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVerifiedAccessGroupsResponse(
    verifiedAccessGroups: Optional[
      Iterable[zio.aws.ec2.model.VerifiedAccessGroup]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessGroupsResponse = {
    import DescribeVerifiedAccessGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessGroupsResponse
      .builder()
      .optionallyWith(
        verifiedAccessGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.verifiedAccessGroups)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVerifiedAccessGroupsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVerifiedAccessGroupsResponse.wrap(buildAwsValue())
}
object DescribeVerifiedAccessGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVerifiedAccessGroupsResponse =
      zio.aws.ec2.model.DescribeVerifiedAccessGroupsResponse(
        verifiedAccessGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def verifiedAccessGroups
        : Optional[List[zio.aws.ec2.model.VerifiedAccessGroup.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getVerifiedAccessGroups: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.VerifiedAccessGroup.ReadOnly
    ]] =
      AwsError.unwrapOptionField("verifiedAccessGroups", verifiedAccessGroups)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessGroupsResponse
  ) extends zio.aws.ec2.model.DescribeVerifiedAccessGroupsResponse.ReadOnly {
    override val verifiedAccessGroups
        : Optional[List[zio.aws.ec2.model.VerifiedAccessGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.VerifiedAccessGroup.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessGroupsResponse
  ): zio.aws.ec2.model.DescribeVerifiedAccessGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
