package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTransitGatewayRouteTableAnnouncementResponse(
    transitGatewayRouteTableAnnouncement: Optional[
      zio.aws.ec2.model.TransitGatewayRouteTableAnnouncement
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableAnnouncementResponse = {
    import CreateTransitGatewayRouteTableAnnouncementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableAnnouncementResponse
      .builder()
      .optionallyWith(
        transitGatewayRouteTableAnnouncement.map(value => value.buildAwsValue())
      )(_.transitGatewayRouteTableAnnouncement)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateTransitGatewayRouteTableAnnouncementResponse.ReadOnly =
    zio.aws.ec2.model.CreateTransitGatewayRouteTableAnnouncementResponse
      .wrap(buildAwsValue())
}
object CreateTransitGatewayRouteTableAnnouncementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableAnnouncementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.CreateTransitGatewayRouteTableAnnouncementResponse =
      zio.aws.ec2.model.CreateTransitGatewayRouteTableAnnouncementResponse(
        transitGatewayRouteTableAnnouncement.map(value => value.asEditable)
      )
    def transitGatewayRouteTableAnnouncement: Optional[
      zio.aws.ec2.model.TransitGatewayRouteTableAnnouncement.ReadOnly
    ]
    def getTransitGatewayRouteTableAnnouncement: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayRouteTableAnnouncement.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayRouteTableAnnouncement",
      transitGatewayRouteTableAnnouncement
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableAnnouncementResponse
  ) extends zio.aws.ec2.model.CreateTransitGatewayRouteTableAnnouncementResponse.ReadOnly {
    override val transitGatewayRouteTableAnnouncement: Optional[
      zio.aws.ec2.model.TransitGatewayRouteTableAnnouncement.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayRouteTableAnnouncement())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayRouteTableAnnouncement.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTransitGatewayRouteTableAnnouncementResponse
  ): zio.aws.ec2.model.CreateTransitGatewayRouteTableAnnouncementResponse.ReadOnly =
    new Wrapper(impl)
}
