package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTrafficMirrorTargetResponse(
    trafficMirrorTarget: Optional[zio.aws.ec2.model.TrafficMirrorTarget] =
      Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetResponse = {
    import CreateTrafficMirrorTargetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetResponse
      .builder()
      .optionallyWith(trafficMirrorTarget.map(value => value.buildAwsValue()))(
        _.trafficMirrorTarget
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateTrafficMirrorTargetResponse.ReadOnly =
    zio.aws.ec2.model.CreateTrafficMirrorTargetResponse.wrap(buildAwsValue())
}
object CreateTrafficMirrorTargetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateTrafficMirrorTargetResponse =
      zio.aws.ec2.model.CreateTrafficMirrorTargetResponse(
        trafficMirrorTarget.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def trafficMirrorTarget
        : Optional[zio.aws.ec2.model.TrafficMirrorTarget.ReadOnly]
    def clientToken: Optional[String]
    def getTrafficMirrorTarget
        : ZIO[Any, AwsError, zio.aws.ec2.model.TrafficMirrorTarget.ReadOnly] =
      AwsError.unwrapOptionField("trafficMirrorTarget", trafficMirrorTarget)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetResponse
  ) extends zio.aws.ec2.model.CreateTrafficMirrorTargetResponse.ReadOnly {
    override val trafficMirrorTarget
        : Optional[zio.aws.ec2.model.TrafficMirrorTarget.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficMirrorTarget())
        .map(value => zio.aws.ec2.model.TrafficMirrorTarget.wrap(value))
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateTrafficMirrorTargetResponse
  ): zio.aws.ec2.model.CreateTrafficMirrorTargetResponse.ReadOnly = new Wrapper(
    impl
  )
}
