package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{MillisecondDateTime, Integer, DateTime}
import scala.jdk.CollectionConverters._
final case class CreateSnapshotResponse(
    dataEncryptionKeyId: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    encrypted: Optional[Boolean] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    progress: Optional[String] = Optional.Absent,
    snapshotId: Optional[String] = Optional.Absent,
    startTime: Optional[DateTime] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.SnapshotState] = Optional.Absent,
    stateMessage: Optional[String] = Optional.Absent,
    volumeId: Optional[String] = Optional.Absent,
    volumeSize: Optional[Integer] = Optional.Absent,
    ownerAlias: Optional[String] = Optional.Absent,
    outpostArn: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    storageTier: Optional[zio.aws.ec2.model.StorageTier] = Optional.Absent,
    restoreExpiryTime: Optional[MillisecondDateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateSnapshotResponse = {
    import CreateSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateSnapshotResponse
      .builder()
      .optionallyWith(
        dataEncryptionKeyId.map(value => value: java.lang.String)
      )(_.dataEncryptionKeyId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(progress.map(value => value: java.lang.String))(
        _.progress
      )
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateMessage.map(value => value: java.lang.String))(
        _.stateMessage
      )
      .optionallyWith(volumeId.map(value => value: java.lang.String))(
        _.volumeId
      )
      .optionallyWith(volumeSize.map(value => value: java.lang.Integer))(
        _.volumeSize
      )
      .optionallyWith(ownerAlias.map(value => value: java.lang.String))(
        _.ownerAlias
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(storageTier.map(value => value.unwrap))(_.storageTier)
      .optionallyWith(
        restoreExpiryTime.map(value =>
          MillisecondDateTime.unwrap(value): Instant
        )
      )(_.restoreExpiryTime)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateSnapshotResponse.ReadOnly =
    zio.aws.ec2.model.CreateSnapshotResponse.wrap(buildAwsValue())
}
object CreateSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateSnapshotResponse =
      zio.aws.ec2.model.CreateSnapshotResponse(
        dataEncryptionKeyId.map(value => value),
        description.map(value => value),
        encrypted.map(value => value),
        kmsKeyId.map(value => value),
        ownerId.map(value => value),
        progress.map(value => value),
        snapshotId.map(value => value),
        startTime.map(value => value),
        state.map(value => value),
        stateMessage.map(value => value),
        volumeId.map(value => value),
        volumeSize.map(value => value),
        ownerAlias.map(value => value),
        outpostArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        storageTier.map(value => value),
        restoreExpiryTime.map(value => value)
      )
    def dataEncryptionKeyId: Optional[String]
    def description: Optional[String]
    def encrypted: Optional[Boolean]
    def kmsKeyId: Optional[String]
    def ownerId: Optional[String]
    def progress: Optional[String]
    def snapshotId: Optional[String]
    def startTime: Optional[DateTime]
    def state: Optional[zio.aws.ec2.model.SnapshotState]
    def stateMessage: Optional[String]
    def volumeId: Optional[String]
    def volumeSize: Optional[Integer]
    def ownerAlias: Optional[String]
    def outpostArn: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def storageTier: Optional[zio.aws.ec2.model.StorageTier]
    def restoreExpiryTime: Optional[MillisecondDateTime]
    def getDataEncryptionKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataEncryptionKeyId", dataEncryptionKeyId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("progress", progress)
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.SnapshotState] =
      AwsError.unwrapOptionField("state", state)
    def getStateMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("stateMessage", stateMessage)
    def getVolumeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getVolumeSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
    def getOwnerAlias: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerAlias", ownerAlias)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getStorageTier: ZIO[Any, AwsError, zio.aws.ec2.model.StorageTier] =
      AwsError.unwrapOptionField("storageTier", storageTier)
    def getRestoreExpiryTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("restoreExpiryTime", restoreExpiryTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateSnapshotResponse
  ) extends zio.aws.ec2.model.CreateSnapshotResponse.ReadOnly {
    override val dataEncryptionKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataEncryptionKeyId())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val encrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: Boolean)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val progress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.progress())
      .map(value => value: String)
    override val snapshotId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => value: String)
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.ec2.model.primitives.DateTime(value))
    override val state: Optional[zio.aws.ec2.model.SnapshotState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.SnapshotState.wrap(value))
    override val stateMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.stateMessage())
      .map(value => value: String)
    override val volumeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeId())
      .map(value => value: String)
    override val volumeSize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeSize())
      .map(value => value: Integer)
    override val ownerAlias: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAlias())
      .map(value => value: String)
    override val outpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val storageTier: Optional[zio.aws.ec2.model.StorageTier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageTier())
        .map(value => zio.aws.ec2.model.StorageTier.wrap(value))
    override val restoreExpiryTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.restoreExpiryTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateSnapshotResponse
  ): zio.aws.ec2.model.CreateSnapshotResponse.ReadOnly = new Wrapper(impl)
}
