package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, NetworkAclId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateNetworkAclEntryRequest(
    cidrBlock: Optional[String] = Optional.Absent,
    egress: Boolean,
    icmpTypeCode: Optional[zio.aws.ec2.model.IcmpTypeCode] = Optional.Absent,
    ipv6CidrBlock: Optional[String] = Optional.Absent,
    networkAclId: NetworkAclId,
    portRange: Optional[zio.aws.ec2.model.PortRange] = Optional.Absent,
    protocol: String,
    ruleAction: zio.aws.ec2.model.RuleAction,
    ruleNumber: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateNetworkAclEntryRequest = {
    import CreateNetworkAclEntryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateNetworkAclEntryRequest
      .builder()
      .optionallyWith(cidrBlock.map(value => value: java.lang.String))(
        _.cidrBlock
      )
      .egress(egress: java.lang.Boolean)
      .optionallyWith(icmpTypeCode.map(value => value.buildAwsValue()))(
        _.icmpTypeCode
      )
      .optionallyWith(ipv6CidrBlock.map(value => value: java.lang.String))(
        _.ipv6CidrBlock
      )
      .networkAclId(NetworkAclId.unwrap(networkAclId): java.lang.String)
      .optionallyWith(portRange.map(value => value.buildAwsValue()))(
        _.portRange
      )
      .protocol(protocol: java.lang.String)
      .ruleAction(ruleAction.unwrap)
      .ruleNumber(ruleNumber: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateNetworkAclEntryRequest.ReadOnly =
    zio.aws.ec2.model.CreateNetworkAclEntryRequest.wrap(buildAwsValue())
}
object CreateNetworkAclEntryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateNetworkAclEntryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateNetworkAclEntryRequest =
      zio.aws.ec2.model.CreateNetworkAclEntryRequest(
        cidrBlock.map(value => value),
        egress,
        icmpTypeCode.map(value => value.asEditable),
        ipv6CidrBlock.map(value => value),
        networkAclId,
        portRange.map(value => value.asEditable),
        protocol,
        ruleAction,
        ruleNumber
      )
    def cidrBlock: Optional[String]
    def egress: Boolean
    def icmpTypeCode: Optional[zio.aws.ec2.model.IcmpTypeCode.ReadOnly]
    def ipv6CidrBlock: Optional[String]
    def networkAclId: NetworkAclId
    def portRange: Optional[zio.aws.ec2.model.PortRange.ReadOnly]
    def protocol: String
    def ruleAction: zio.aws.ec2.model.RuleAction
    def ruleNumber: Integer
    def getCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cidrBlock", cidrBlock)
    def getEgress: ZIO[Any, Nothing, Boolean] = ZIO.succeed(egress)
    def getIcmpTypeCode
        : ZIO[Any, AwsError, zio.aws.ec2.model.IcmpTypeCode.ReadOnly] =
      AwsError.unwrapOptionField("icmpTypeCode", icmpTypeCode)
    def getIpv6CidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6CidrBlock", ipv6CidrBlock)
    def getNetworkAclId: ZIO[Any, Nothing, NetworkAclId] =
      ZIO.succeed(networkAclId)
    def getPortRange: ZIO[Any, AwsError, zio.aws.ec2.model.PortRange.ReadOnly] =
      AwsError.unwrapOptionField("portRange", portRange)
    def getProtocol: ZIO[Any, Nothing, String] = ZIO.succeed(protocol)
    def getRuleAction: ZIO[Any, Nothing, zio.aws.ec2.model.RuleAction] =
      ZIO.succeed(ruleAction)
    def getRuleNumber: ZIO[Any, Nothing, Integer] = ZIO.succeed(ruleNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkAclEntryRequest
  ) extends zio.aws.ec2.model.CreateNetworkAclEntryRequest.ReadOnly {
    override val cidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cidrBlock())
      .map(value => value: String)
    override val egress: Boolean = impl.egress(): Boolean
    override val icmpTypeCode
        : Optional[zio.aws.ec2.model.IcmpTypeCode.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.icmpTypeCode())
        .map(value => zio.aws.ec2.model.IcmpTypeCode.wrap(value))
    override val ipv6CidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6CidrBlock())
      .map(value => value: String)
    override val networkAclId: NetworkAclId =
      zio.aws.ec2.model.primitives.NetworkAclId(impl.networkAclId())
    override val portRange: Optional[zio.aws.ec2.model.PortRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portRange())
        .map(value => zio.aws.ec2.model.PortRange.wrap(value))
    override val protocol: String = impl.protocol(): String
    override val ruleAction: zio.aws.ec2.model.RuleAction =
      zio.aws.ec2.model.RuleAction.wrap(impl.ruleAction())
    override val ruleNumber: Integer = impl.ruleNumber(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkAclEntryRequest
  ): zio.aws.ec2.model.CreateNetworkAclEntryRequest.ReadOnly = new Wrapper(impl)
}
