package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VersionDescription, LaunchTemplateName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLaunchTemplateRequest(
    clientToken: Optional[String] = Optional.Absent,
    launchTemplateName: LaunchTemplateName,
    versionDescription: Optional[VersionDescription] = Optional.Absent,
    launchTemplateData: zio.aws.ec2.model.RequestLaunchTemplateData,
    tagSpecifications: Optional[Iterable[zio.aws.ec2.model.TagSpecification]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateRequest = {
    import CreateLaunchTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .launchTemplateName(
        LaunchTemplateName.unwrap(launchTemplateName): java.lang.String
      )
      .optionallyWith(
        versionDescription.map(value =>
          VersionDescription.unwrap(value): java.lang.String
        )
      )(_.versionDescription)
      .launchTemplateData(launchTemplateData.buildAwsValue())
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateLaunchTemplateRequest.ReadOnly =
    zio.aws.ec2.model.CreateLaunchTemplateRequest.wrap(buildAwsValue())
}
object CreateLaunchTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateLaunchTemplateRequest =
      zio.aws.ec2.model.CreateLaunchTemplateRequest(
        clientToken.map(value => value),
        launchTemplateName,
        versionDescription.map(value => value),
        launchTemplateData.asEditable,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientToken: Optional[String]
    def launchTemplateName: LaunchTemplateName
    def versionDescription: Optional[VersionDescription]
    def launchTemplateData: zio.aws.ec2.model.RequestLaunchTemplateData.ReadOnly
    def tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getLaunchTemplateName: ZIO[Any, Nothing, LaunchTemplateName] =
      ZIO.succeed(launchTemplateName)
    def getVersionDescription: ZIO[Any, AwsError, VersionDescription] =
      AwsError.unwrapOptionField("versionDescription", versionDescription)
    def getLaunchTemplateData: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.RequestLaunchTemplateData.ReadOnly
    ] = ZIO.succeed(launchTemplateData)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateRequest
  ) extends zio.aws.ec2.model.CreateLaunchTemplateRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val launchTemplateName: LaunchTemplateName =
      zio.aws.ec2.model.primitives.LaunchTemplateName(impl.launchTemplateName())
    override val versionDescription: Optional[VersionDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionDescription())
        .map(value => zio.aws.ec2.model.primitives.VersionDescription(value))
    override val launchTemplateData
        : zio.aws.ec2.model.RequestLaunchTemplateData.ReadOnly =
      zio.aws.ec2.model.RequestLaunchTemplateData
        .wrap(impl.launchTemplateData())
    override val tagSpecifications
        : Optional[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagSpecifications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.TagSpecification.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateRequest
  ): zio.aws.ec2.model.CreateLaunchTemplateRequest.ReadOnly = new Wrapper(impl)
}
