package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  NetworkInterfaceId,
  EipAllocationPublicIp,
  InstanceId,
  AllocationId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssociateAddressRequest(
    allocationId: Optional[AllocationId] = Optional.Absent,
    instanceId: Optional[InstanceId] = Optional.Absent,
    publicIp: Optional[EipAllocationPublicIp] = Optional.Absent,
    allowReassociation: Optional[Boolean] = Optional.Absent,
    networkInterfaceId: Optional[NetworkInterfaceId] = Optional.Absent,
    privateIpAddress: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssociateAddressRequest = {
    import AssociateAddressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssociateAddressRequest
      .builder()
      .optionallyWith(
        allocationId.map(value => AllocationId.unwrap(value): java.lang.String)
      )(_.allocationId)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        publicIp.map(value =>
          EipAllocationPublicIp.unwrap(value): java.lang.String
        )
      )(_.publicIp)
      .optionallyWith(
        allowReassociation.map(value => value: java.lang.Boolean)
      )(_.allowReassociation)
      .optionallyWith(
        networkInterfaceId.map(value =>
          NetworkInterfaceId.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(privateIpAddress.map(value => value: java.lang.String))(
        _.privateIpAddress
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssociateAddressRequest.ReadOnly =
    zio.aws.ec2.model.AssociateAddressRequest.wrap(buildAwsValue())
}
object AssociateAddressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssociateAddressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssociateAddressRequest =
      zio.aws.ec2.model.AssociateAddressRequest(
        allocationId.map(value => value),
        instanceId.map(value => value),
        publicIp.map(value => value),
        allowReassociation.map(value => value),
        networkInterfaceId.map(value => value),
        privateIpAddress.map(value => value)
      )
    def allocationId: Optional[AllocationId]
    def instanceId: Optional[InstanceId]
    def publicIp: Optional[EipAllocationPublicIp]
    def allowReassociation: Optional[Boolean]
    def networkInterfaceId: Optional[NetworkInterfaceId]
    def privateIpAddress: Optional[String]
    def getAllocationId: ZIO[Any, AwsError, AllocationId] =
      AwsError.unwrapOptionField("allocationId", allocationId)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getPublicIp: ZIO[Any, AwsError, EipAllocationPublicIp] =
      AwsError.unwrapOptionField("publicIp", publicIp)
    def getAllowReassociation: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allowReassociation", allowReassociation)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NetworkInterfaceId] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getPrivateIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssociateAddressRequest
  ) extends zio.aws.ec2.model.AssociateAddressRequest.ReadOnly {
    override val allocationId: Optional[AllocationId] = zio.aws.core.internal
      .optionalFromNullable(impl.allocationId())
      .map(value => zio.aws.ec2.model.primitives.AllocationId(value))
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.ec2.model.primitives.InstanceId(value))
    override val publicIp: Optional[EipAllocationPublicIp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicIp())
        .map(value => zio.aws.ec2.model.primitives.EipAllocationPublicIp(value))
    override val allowReassociation: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.allowReassociation())
      .map(value => value: Boolean)
    override val networkInterfaceId: Optional[NetworkInterfaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceId())
        .map(value => zio.aws.ec2.model.primitives.NetworkInterfaceId(value))
    override val privateIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddress())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssociateAddressRequest
  ): zio.aws.ec2.model.AssociateAddressRequest.ReadOnly = new Wrapper(impl)
}
