package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait AnalysisStatus {
  def unwrap: software.amazon.awssdk.services.ec2.model.AnalysisStatus
}
object AnalysisStatus {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.AnalysisStatus
  ): zio.aws.ec2.model.AnalysisStatus = value match {
    case software.amazon.awssdk.services.ec2.model.AnalysisStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.AnalysisStatus.RUNNING =>
      val r = running
      r
    case software.amazon.awssdk.services.ec2.model.AnalysisStatus.SUCCEEDED =>
      val r = succeeded
      r
    case software.amazon.awssdk.services.ec2.model.AnalysisStatus.FAILED =>
      val r = failed
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.AnalysisStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AnalysisStatus =
      software.amazon.awssdk.services.ec2.model.AnalysisStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object running extends zio.aws.ec2.model.AnalysisStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AnalysisStatus =
      software.amazon.awssdk.services.ec2.model.AnalysisStatus.RUNNING
  }
  case object succeeded extends zio.aws.ec2.model.AnalysisStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AnalysisStatus =
      software.amazon.awssdk.services.ec2.model.AnalysisStatus.SUCCEEDED
  }
  case object failed extends zio.aws.ec2.model.AnalysisStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AnalysisStatus =
      software.amazon.awssdk.services.ec2.model.AnalysisStatus.FAILED
  }
}
