package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifiedAccessLogs(
    s3: Optional[zio.aws.ec2.model.VerifiedAccessLogS3Destination] =
      Optional.Absent,
    cloudWatchLogs: Optional[
      zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestination
    ] = Optional.Absent,
    kinesisDataFirehose: Optional[
      zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestination
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VerifiedAccessLogs = {
    import VerifiedAccessLogs.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VerifiedAccessLogs
      .builder()
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .optionallyWith(cloudWatchLogs.map(value => value.buildAwsValue()))(
        _.cloudWatchLogs
      )
      .optionallyWith(kinesisDataFirehose.map(value => value.buildAwsValue()))(
        _.kinesisDataFirehose
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VerifiedAccessLogs.ReadOnly =
    zio.aws.ec2.model.VerifiedAccessLogs.wrap(buildAwsValue())
}
object VerifiedAccessLogs {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VerifiedAccessLogs
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VerifiedAccessLogs =
      zio.aws.ec2.model.VerifiedAccessLogs(
        s3.map(value => value.asEditable),
        cloudWatchLogs.map(value => value.asEditable),
        kinesisDataFirehose.map(value => value.asEditable)
      )
    def s3: Optional[zio.aws.ec2.model.VerifiedAccessLogS3Destination.ReadOnly]
    def cloudWatchLogs: Optional[
      zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestination.ReadOnly
    ]
    def kinesisDataFirehose: Optional[
      zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestination.ReadOnly
    ]
    def getS3: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessLogS3Destination.ReadOnly
    ] = AwsError.unwrapOptionField("s3", s3)
    def getCloudWatchLogs: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestination.ReadOnly
    ] = AwsError.unwrapOptionField("cloudWatchLogs", cloudWatchLogs)
    def getKinesisDataFirehose: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestination.ReadOnly
    ] = AwsError.unwrapOptionField("kinesisDataFirehose", kinesisDataFirehose)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessLogs
  ) extends zio.aws.ec2.model.VerifiedAccessLogs.ReadOnly {
    override val s3
        : Optional[zio.aws.ec2.model.VerifiedAccessLogS3Destination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3())
        .map(value =>
          zio.aws.ec2.model.VerifiedAccessLogS3Destination.wrap(value)
        )
    override val cloudWatchLogs: Optional[
      zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestination.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLogs())
      .map(value =>
        zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestination.wrap(value)
      )
    override val kinesisDataFirehose: Optional[
      zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestination.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisDataFirehose())
      .map(value =>
        zio.aws.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestination
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessLogs
  ): zio.aws.ec2.model.VerifiedAccessLogs.ReadOnly = new Wrapper(impl)
}
