package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayConnectRequestBgpOptions(
    peerAsn: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayConnectRequestBgpOptions = {
    import TransitGatewayConnectRequestBgpOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayConnectRequestBgpOptions
      .builder()
      .optionallyWith(peerAsn.map(value => value: java.lang.Long))(_.peerAsn)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.TransitGatewayConnectRequestBgpOptions.ReadOnly =
    zio.aws.ec2.model.TransitGatewayConnectRequestBgpOptions
      .wrap(buildAwsValue())
}
object TransitGatewayConnectRequestBgpOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayConnectRequestBgpOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayConnectRequestBgpOptions =
      zio.aws.ec2.model
        .TransitGatewayConnectRequestBgpOptions(peerAsn.map(value => value))
    def peerAsn: Optional[Long]
    def getPeerAsn: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("peerAsn", peerAsn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayConnectRequestBgpOptions
  ) extends zio.aws.ec2.model.TransitGatewayConnectRequestBgpOptions.ReadOnly {
    override val peerAsn: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.peerAsn())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayConnectRequestBgpOptions
  ): zio.aws.ec2.model.TransitGatewayConnectRequestBgpOptions.ReadOnly =
    new Wrapper(impl)
}
