package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TargetStorageTier {
  def unwrap: software.amazon.awssdk.services.ec2.model.TargetStorageTier
}
object TargetStorageTier {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TargetStorageTier
  ): zio.aws.ec2.model.TargetStorageTier = value match {
    case software.amazon.awssdk.services.ec2.model.TargetStorageTier.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TargetStorageTier.ARCHIVE =>
      val r = archive
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.TargetStorageTier {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TargetStorageTier =
      software.amazon.awssdk.services.ec2.model.TargetStorageTier.UNKNOWN_TO_SDK_VERSION
  }
  case object archive extends zio.aws.ec2.model.TargetStorageTier {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TargetStorageTier =
      software.amazon.awssdk.services.ec2.model.TargetStorageTier.ARCHIVE
  }
}
