package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait TargetCapacityUnitType {
  def unwrap: software.amazon.awssdk.services.ec2.model.TargetCapacityUnitType
}
object TargetCapacityUnitType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.TargetCapacityUnitType
  ): zio.aws.ec2.model.TargetCapacityUnitType = value match {
    case software.amazon.awssdk.services.ec2.model.TargetCapacityUnitType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.TargetCapacityUnitType.VCPU =>
      val r = vcpu
      r
    case software.amazon.awssdk.services.ec2.model.TargetCapacityUnitType.MEMORY_MIB =>
      val r = `memory-mib`
      r
    case software.amazon.awssdk.services.ec2.model.TargetCapacityUnitType.UNITS =>
      val r = units
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.TargetCapacityUnitType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TargetCapacityUnitType =
      software.amazon.awssdk.services.ec2.model.TargetCapacityUnitType.UNKNOWN_TO_SDK_VERSION
  }
  case object vcpu extends zio.aws.ec2.model.TargetCapacityUnitType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TargetCapacityUnitType =
      software.amazon.awssdk.services.ec2.model.TargetCapacityUnitType.VCPU
  }
  case object `memory-mib` extends zio.aws.ec2.model.TargetCapacityUnitType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TargetCapacityUnitType =
      software.amazon.awssdk.services.ec2.model.TargetCapacityUnitType.MEMORY_MIB
  }
  case object units extends zio.aws.ec2.model.TargetCapacityUnitType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.TargetCapacityUnitType =
      software.amazon.awssdk.services.ec2.model.TargetCapacityUnitType.UNITS
  }
}
