package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PathComponent(
    sequenceNumber: Optional[Integer] = Optional.Absent,
    aclRule: Optional[zio.aws.ec2.model.AnalysisAclRule] = Optional.Absent,
    attachedTo: Optional[zio.aws.ec2.model.AnalysisComponent] = Optional.Absent,
    component: Optional[zio.aws.ec2.model.AnalysisComponent] = Optional.Absent,
    destinationVpc: Optional[zio.aws.ec2.model.AnalysisComponent] =
      Optional.Absent,
    outboundHeader: Optional[zio.aws.ec2.model.AnalysisPacketHeader] =
      Optional.Absent,
    inboundHeader: Optional[zio.aws.ec2.model.AnalysisPacketHeader] =
      Optional.Absent,
    routeTableRoute: Optional[zio.aws.ec2.model.AnalysisRouteTableRoute] =
      Optional.Absent,
    securityGroupRule: Optional[zio.aws.ec2.model.AnalysisSecurityGroupRule] =
      Optional.Absent,
    sourceVpc: Optional[zio.aws.ec2.model.AnalysisComponent] = Optional.Absent,
    subnet: Optional[zio.aws.ec2.model.AnalysisComponent] = Optional.Absent,
    vpc: Optional[zio.aws.ec2.model.AnalysisComponent] = Optional.Absent,
    additionalDetails: Optional[Iterable[zio.aws.ec2.model.AdditionalDetail]] =
      Optional.Absent,
    transitGateway: Optional[zio.aws.ec2.model.AnalysisComponent] =
      Optional.Absent,
    transitGatewayRouteTableRoute: Optional[
      zio.aws.ec2.model.TransitGatewayRouteTableRoute
    ] = Optional.Absent,
    explanations: Optional[Iterable[zio.aws.ec2.model.Explanation]] =
      Optional.Absent,
    elasticLoadBalancerListener: Optional[zio.aws.ec2.model.AnalysisComponent] =
      Optional.Absent,
    firewallStatelessRule: Optional[zio.aws.ec2.model.FirewallStatelessRule] =
      Optional.Absent,
    firewallStatefulRule: Optional[zio.aws.ec2.model.FirewallStatefulRule] =
      Optional.Absent,
    serviceName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PathComponent = {
    import PathComponent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PathComponent
      .builder()
      .optionallyWith(sequenceNumber.map(value => value: java.lang.Integer))(
        _.sequenceNumber
      )
      .optionallyWith(aclRule.map(value => value.buildAwsValue()))(_.aclRule)
      .optionallyWith(attachedTo.map(value => value.buildAwsValue()))(
        _.attachedTo
      )
      .optionallyWith(component.map(value => value.buildAwsValue()))(
        _.component
      )
      .optionallyWith(destinationVpc.map(value => value.buildAwsValue()))(
        _.destinationVpc
      )
      .optionallyWith(outboundHeader.map(value => value.buildAwsValue()))(
        _.outboundHeader
      )
      .optionallyWith(inboundHeader.map(value => value.buildAwsValue()))(
        _.inboundHeader
      )
      .optionallyWith(routeTableRoute.map(value => value.buildAwsValue()))(
        _.routeTableRoute
      )
      .optionallyWith(securityGroupRule.map(value => value.buildAwsValue()))(
        _.securityGroupRule
      )
      .optionallyWith(sourceVpc.map(value => value.buildAwsValue()))(
        _.sourceVpc
      )
      .optionallyWith(subnet.map(value => value.buildAwsValue()))(_.subnet)
      .optionallyWith(vpc.map(value => value.buildAwsValue()))(_.vpc)
      .optionallyWith(
        additionalDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalDetails)
      .optionallyWith(transitGateway.map(value => value.buildAwsValue()))(
        _.transitGateway
      )
      .optionallyWith(
        transitGatewayRouteTableRoute.map(value => value.buildAwsValue())
      )(_.transitGatewayRouteTableRoute)
      .optionallyWith(
        explanations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.explanations)
      .optionallyWith(
        elasticLoadBalancerListener.map(value => value.buildAwsValue())
      )(_.elasticLoadBalancerListener)
      .optionallyWith(
        firewallStatelessRule.map(value => value.buildAwsValue())
      )(_.firewallStatelessRule)
      .optionallyWith(firewallStatefulRule.map(value => value.buildAwsValue()))(
        _.firewallStatefulRule
      )
      .optionallyWith(serviceName.map(value => value: java.lang.String))(
        _.serviceName
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PathComponent.ReadOnly =
    zio.aws.ec2.model.PathComponent.wrap(buildAwsValue())
}
object PathComponent {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.PathComponent] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PathComponent =
      zio.aws.ec2.model.PathComponent(
        sequenceNumber.map(value => value),
        aclRule.map(value => value.asEditable),
        attachedTo.map(value => value.asEditable),
        component.map(value => value.asEditable),
        destinationVpc.map(value => value.asEditable),
        outboundHeader.map(value => value.asEditable),
        inboundHeader.map(value => value.asEditable),
        routeTableRoute.map(value => value.asEditable),
        securityGroupRule.map(value => value.asEditable),
        sourceVpc.map(value => value.asEditable),
        subnet.map(value => value.asEditable),
        vpc.map(value => value.asEditable),
        additionalDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        transitGateway.map(value => value.asEditable),
        transitGatewayRouteTableRoute.map(value => value.asEditable),
        explanations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        elasticLoadBalancerListener.map(value => value.asEditable),
        firewallStatelessRule.map(value => value.asEditable),
        firewallStatefulRule.map(value => value.asEditable),
        serviceName.map(value => value)
      )
    def sequenceNumber: Optional[Integer]
    def aclRule: Optional[zio.aws.ec2.model.AnalysisAclRule.ReadOnly]
    def attachedTo: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def component: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def destinationVpc: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def outboundHeader
        : Optional[zio.aws.ec2.model.AnalysisPacketHeader.ReadOnly]
    def inboundHeader: Optional[zio.aws.ec2.model.AnalysisPacketHeader.ReadOnly]
    def routeTableRoute
        : Optional[zio.aws.ec2.model.AnalysisRouteTableRoute.ReadOnly]
    def securityGroupRule
        : Optional[zio.aws.ec2.model.AnalysisSecurityGroupRule.ReadOnly]
    def sourceVpc: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def subnet: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def vpc: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def additionalDetails
        : Optional[List[zio.aws.ec2.model.AdditionalDetail.ReadOnly]]
    def transitGateway: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def transitGatewayRouteTableRoute
        : Optional[zio.aws.ec2.model.TransitGatewayRouteTableRoute.ReadOnly]
    def explanations: Optional[List[zio.aws.ec2.model.Explanation.ReadOnly]]
    def elasticLoadBalancerListener
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly]
    def firewallStatelessRule
        : Optional[zio.aws.ec2.model.FirewallStatelessRule.ReadOnly]
    def firewallStatefulRule
        : Optional[zio.aws.ec2.model.FirewallStatefulRule.ReadOnly]
    def serviceName: Optional[String]
    def getSequenceNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sequenceNumber", sequenceNumber)
    def getAclRule
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisAclRule.ReadOnly] =
      AwsError.unwrapOptionField("aclRule", aclRule)
    def getAttachedTo
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("attachedTo", attachedTo)
    def getComponent
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("component", component)
    def getDestinationVpc
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("destinationVpc", destinationVpc)
    def getOutboundHeader
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisPacketHeader.ReadOnly] =
      AwsError.unwrapOptionField("outboundHeader", outboundHeader)
    def getInboundHeader
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisPacketHeader.ReadOnly] =
      AwsError.unwrapOptionField("inboundHeader", inboundHeader)
    def getRouteTableRoute: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AnalysisRouteTableRoute.ReadOnly
    ] = AwsError.unwrapOptionField("routeTableRoute", routeTableRoute)
    def getSecurityGroupRule: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.AnalysisSecurityGroupRule.ReadOnly
    ] = AwsError.unwrapOptionField("securityGroupRule", securityGroupRule)
    def getSourceVpc
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("sourceVpc", sourceVpc)
    def getSubnet
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("subnet", subnet)
    def getVpc
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("vpc", vpc)
    def getAdditionalDetails: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AdditionalDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("additionalDetails", additionalDetails)
    def getTransitGateway
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField("transitGateway", transitGateway)
    def getTransitGatewayRouteTableRoute: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayRouteTableRoute.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayRouteTableRoute",
      transitGatewayRouteTableRoute
    )
    def getExplanations
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Explanation.ReadOnly]] =
      AwsError.unwrapOptionField("explanations", explanations)
    def getElasticLoadBalancerListener
        : ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      AwsError.unwrapOptionField(
        "elasticLoadBalancerListener",
        elasticLoadBalancerListener
      )
    def getFirewallStatelessRule
        : ZIO[Any, AwsError, zio.aws.ec2.model.FirewallStatelessRule.ReadOnly] =
      AwsError.unwrapOptionField("firewallStatelessRule", firewallStatelessRule)
    def getFirewallStatefulRule
        : ZIO[Any, AwsError, zio.aws.ec2.model.FirewallStatefulRule.ReadOnly] =
      AwsError.unwrapOptionField("firewallStatefulRule", firewallStatefulRule)
    def getServiceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceName", serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PathComponent
  ) extends zio.aws.ec2.model.PathComponent.ReadOnly {
    override val sequenceNumber: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sequenceNumber())
      .map(value => value: Integer)
    override val aclRule: Optional[zio.aws.ec2.model.AnalysisAclRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aclRule())
        .map(value => zio.aws.ec2.model.AnalysisAclRule.wrap(value))
    override val attachedTo
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachedTo())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val component
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.component())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val destinationVpc
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationVpc())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val outboundHeader
        : Optional[zio.aws.ec2.model.AnalysisPacketHeader.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outboundHeader())
        .map(value => zio.aws.ec2.model.AnalysisPacketHeader.wrap(value))
    override val inboundHeader
        : Optional[zio.aws.ec2.model.AnalysisPacketHeader.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inboundHeader())
        .map(value => zio.aws.ec2.model.AnalysisPacketHeader.wrap(value))
    override val routeTableRoute
        : Optional[zio.aws.ec2.model.AnalysisRouteTableRoute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.routeTableRoute())
        .map(value => zio.aws.ec2.model.AnalysisRouteTableRoute.wrap(value))
    override val securityGroupRule
        : Optional[zio.aws.ec2.model.AnalysisSecurityGroupRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupRule())
        .map(value => zio.aws.ec2.model.AnalysisSecurityGroupRule.wrap(value))
    override val sourceVpc
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceVpc())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val subnet
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnet())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val vpc: Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpc())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val additionalDetails
        : Optional[List[zio.aws.ec2.model.AdditionalDetail.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalDetails())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AdditionalDetail.wrap(item)
          }.toList
        )
    override val transitGateway
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGateway())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val transitGatewayRouteTableRoute
        : Optional[zio.aws.ec2.model.TransitGatewayRouteTableRoute.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayRouteTableRoute())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayRouteTableRoute.wrap(value)
        )
    override val explanations
        : Optional[List[zio.aws.ec2.model.Explanation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.explanations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Explanation.wrap(item)
          }.toList
        )
    override val elasticLoadBalancerListener
        : Optional[zio.aws.ec2.model.AnalysisComponent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elasticLoadBalancerListener())
        .map(value => zio.aws.ec2.model.AnalysisComponent.wrap(value))
    override val firewallStatelessRule
        : Optional[zio.aws.ec2.model.FirewallStatelessRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallStatelessRule())
        .map(value => zio.aws.ec2.model.FirewallStatelessRule.wrap(value))
    override val firewallStatefulRule
        : Optional[zio.aws.ec2.model.FirewallStatefulRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallStatefulRule())
        .map(value => zio.aws.ec2.model.FirewallStatefulRule.wrap(value))
    override val serviceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PathComponent
  ): zio.aws.ec2.model.PathComponent.ReadOnly = new Wrapper(impl)
}
