package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait NetworkInterfaceType {
  def unwrap: software.amazon.awssdk.services.ec2.model.NetworkInterfaceType
}
object NetworkInterfaceType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.NetworkInterfaceType
  ): zio.aws.ec2.model.NetworkInterfaceType = value match {
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.INTERFACE =>
      val r = interface
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.NAT_GATEWAY =>
      val r = natGateway
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.EFA =>
      val r = efa
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.TRUNK =>
      val r = trunk
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.LOAD_BALANCER =>
      val r = load_balancer
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.NETWORK_LOAD_BALANCER =>
      val r = network_load_balancer
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.VPC_ENDPOINT =>
      val r = vpc_endpoint
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.BRANCH =>
      val r = branch
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.TRANSIT_GATEWAY =>
      val r = transit_gateway
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.LAMBDA =>
      val r = lambda
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.QUICKSIGHT =>
      val r = quicksight
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.GLOBAL_ACCELERATOR_MANAGED =>
      val r = global_accelerator_managed
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.API_GATEWAY_MANAGED =>
      val r = api_gateway_managed
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.GATEWAY_LOAD_BALANCER =>
      val r = gateway_load_balancer
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.GATEWAY_LOAD_BALANCER_ENDPOINT =>
      val r = gateway_load_balancer_endpoint
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.IOT_RULES_MANAGED =>
      val r = iot_rules_managed
      r
    case software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.AWS_CODESTAR_CONNECTIONS_MANAGED =>
      val r = aws_codestar_connections_managed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.UNKNOWN_TO_SDK_VERSION
  }
  case object interface extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.INTERFACE
  }
  case object natGateway extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.NAT_GATEWAY
  }
  case object efa extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.EFA
  }
  case object trunk extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.TRUNK
  }
  case object load_balancer extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.LOAD_BALANCER
  }
  case object network_load_balancer
      extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.NETWORK_LOAD_BALANCER
  }
  case object vpc_endpoint extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.VPC_ENDPOINT
  }
  case object branch extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.BRANCH
  }
  case object transit_gateway extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.TRANSIT_GATEWAY
  }
  case object lambda extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.LAMBDA
  }
  case object quicksight extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.QUICKSIGHT
  }
  case object global_accelerator_managed
      extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.GLOBAL_ACCELERATOR_MANAGED
  }
  case object api_gateway_managed
      extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.API_GATEWAY_MANAGED
  }
  case object gateway_load_balancer
      extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.GATEWAY_LOAD_BALANCER
  }
  case object gateway_load_balancer_endpoint
      extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.GATEWAY_LOAD_BALANCER_ENDPOINT
  }
  case object iot_rules_managed extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.IOT_RULES_MANAGED
  }
  case object aws_codestar_connections_managed
      extends zio.aws.ec2.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.NetworkInterfaceType =
      software.amazon.awssdk.services.ec2.model.NetworkInterfaceType.AWS_CODESTAR_CONNECTIONS_MANAGED
  }
}
