package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVpnConnectionResponse(
    vpnConnection: Optional[zio.aws.ec2.model.VpnConnection] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionResponse = {
    import ModifyVpnConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionResponse
      .builder()
      .optionallyWith(vpnConnection.map(value => value.buildAwsValue()))(
        _.vpnConnection
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyVpnConnectionResponse.ReadOnly =
    zio.aws.ec2.model.ModifyVpnConnectionResponse.wrap(buildAwsValue())
}
object ModifyVpnConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVpnConnectionResponse =
      zio.aws.ec2.model.ModifyVpnConnectionResponse(
        vpnConnection.map(value => value.asEditable)
      )
    def vpnConnection: Optional[zio.aws.ec2.model.VpnConnection.ReadOnly]
    def getVpnConnection
        : ZIO[Any, AwsError, zio.aws.ec2.model.VpnConnection.ReadOnly] =
      AwsError.unwrapOptionField("vpnConnection", vpnConnection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionResponse
  ) extends zio.aws.ec2.model.ModifyVpnConnectionResponse.ReadOnly {
    override val vpnConnection
        : Optional[zio.aws.ec2.model.VpnConnection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpnConnection())
        .map(value => zio.aws.ec2.model.VpnConnection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionResponse
  ): zio.aws.ec2.model.ModifyVpnConnectionResponse.ReadOnly = new Wrapper(impl)
}
