package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVerifiedAccessGroupResponse(
    verifiedAccessGroup: Optional[zio.aws.ec2.model.VerifiedAccessGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupResponse = {
    import ModifyVerifiedAccessGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupResponse
      .builder()
      .optionallyWith(verifiedAccessGroup.map(value => value.buildAwsValue()))(
        _.verifiedAccessGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyVerifiedAccessGroupResponse.ReadOnly =
    zio.aws.ec2.model.ModifyVerifiedAccessGroupResponse.wrap(buildAwsValue())
}
object ModifyVerifiedAccessGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVerifiedAccessGroupResponse =
      zio.aws.ec2.model.ModifyVerifiedAccessGroupResponse(
        verifiedAccessGroup.map(value => value.asEditable)
      )
    def verifiedAccessGroup
        : Optional[zio.aws.ec2.model.VerifiedAccessGroup.ReadOnly]
    def getVerifiedAccessGroup
        : ZIO[Any, AwsError, zio.aws.ec2.model.VerifiedAccessGroup.ReadOnly] =
      AwsError.unwrapOptionField("verifiedAccessGroup", verifiedAccessGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupResponse
  ) extends zio.aws.ec2.model.ModifyVerifiedAccessGroupResponse.ReadOnly {
    override val verifiedAccessGroup
        : Optional[zio.aws.ec2.model.VerifiedAccessGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessGroup())
        .map(value => zio.aws.ec2.model.VerifiedAccessGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupResponse
  ): zio.aws.ec2.model.ModifyVerifiedAccessGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
