package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyIpamScopeResponse(
    ipamScope: Optional[zio.aws.ec2.model.IpamScope] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyIpamScopeResponse = {
    import ModifyIpamScopeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyIpamScopeResponse
      .builder()
      .optionallyWith(ipamScope.map(value => value.buildAwsValue()))(
        _.ipamScope
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyIpamScopeResponse.ReadOnly =
    zio.aws.ec2.model.ModifyIpamScopeResponse.wrap(buildAwsValue())
}
object ModifyIpamScopeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyIpamScopeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyIpamScopeResponse =
      zio.aws.ec2.model
        .ModifyIpamScopeResponse(ipamScope.map(value => value.asEditable))
    def ipamScope: Optional[zio.aws.ec2.model.IpamScope.ReadOnly]
    def getIpamScope: ZIO[Any, AwsError, zio.aws.ec2.model.IpamScope.ReadOnly] =
      AwsError.unwrapOptionField("ipamScope", ipamScope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIpamScopeResponse
  ) extends zio.aws.ec2.model.ModifyIpamScopeResponse.ReadOnly {
    override val ipamScope: Optional[zio.aws.ec2.model.IpamScope.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamScope())
        .map(value => zio.aws.ec2.model.IpamScope.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIpamScopeResponse
  ): zio.aws.ec2.model.ModifyIpamScopeResponse.ReadOnly = new Wrapper(impl)
}
