package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{InstanceId, SecurityGroupId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyInstanceAttributeRequest(
    sourceDestCheck: Optional[zio.aws.ec2.model.AttributeBooleanValue] =
      Optional.Absent,
    attribute: Optional[zio.aws.ec2.model.InstanceAttributeName] =
      Optional.Absent,
    blockDeviceMappings: Optional[
      Iterable[zio.aws.ec2.model.InstanceBlockDeviceMappingSpecification]
    ] = Optional.Absent,
    disableApiTermination: Optional[zio.aws.ec2.model.AttributeBooleanValue] =
      Optional.Absent,
    ebsOptimized: Optional[zio.aws.ec2.model.AttributeBooleanValue] =
      Optional.Absent,
    enaSupport: Optional[zio.aws.ec2.model.AttributeBooleanValue] =
      Optional.Absent,
    groups: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    instanceId: InstanceId,
    instanceInitiatedShutdownBehavior: Optional[
      zio.aws.ec2.model.AttributeValue
    ] = Optional.Absent,
    instanceType: Optional[zio.aws.ec2.model.AttributeValue] = Optional.Absent,
    kernel: Optional[zio.aws.ec2.model.AttributeValue] = Optional.Absent,
    ramdisk: Optional[zio.aws.ec2.model.AttributeValue] = Optional.Absent,
    sriovNetSupport: Optional[zio.aws.ec2.model.AttributeValue] =
      Optional.Absent,
    userData: Optional[zio.aws.ec2.model.BlobAttributeValue] = Optional.Absent,
    value: Optional[String] = Optional.Absent,
    disableApiStop: Optional[zio.aws.ec2.model.AttributeBooleanValue] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeRequest = {
    import ModifyInstanceAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeRequest
      .builder()
      .optionallyWith(sourceDestCheck.map(value => value.buildAwsValue()))(
        _.sourceDestCheck
      )
      .optionallyWith(attribute.map(value => value.unwrap))(_.attribute)
      .optionallyWith(
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blockDeviceMappings)
      .optionallyWith(
        disableApiTermination.map(value => value.buildAwsValue())
      )(_.disableApiTermination)
      .optionallyWith(ebsOptimized.map(value => value.buildAwsValue()))(
        _.ebsOptimized
      )
      .optionallyWith(enaSupport.map(value => value.buildAwsValue()))(
        _.enaSupport
      )
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groups)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        instanceInitiatedShutdownBehavior.map(value => value.buildAwsValue())
      )(_.instanceInitiatedShutdownBehavior)
      .optionallyWith(instanceType.map(value => value.buildAwsValue()))(
        _.instanceType
      )
      .optionallyWith(kernel.map(value => value.buildAwsValue()))(_.kernel)
      .optionallyWith(ramdisk.map(value => value.buildAwsValue()))(_.ramdisk)
      .optionallyWith(sriovNetSupport.map(value => value.buildAwsValue()))(
        _.sriovNetSupport
      )
      .optionallyWith(userData.map(value => value.buildAwsValue()))(_.userData)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(disableApiStop.map(value => value.buildAwsValue()))(
        _.disableApiStop
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyInstanceAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ModifyInstanceAttributeRequest.wrap(buildAwsValue())
}
object ModifyInstanceAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyInstanceAttributeRequest =
      zio.aws.ec2.model.ModifyInstanceAttributeRequest(
        sourceDestCheck.map(value => value.asEditable),
        attribute.map(value => value),
        blockDeviceMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        disableApiTermination.map(value => value.asEditable),
        ebsOptimized.map(value => value.asEditable),
        enaSupport.map(value => value.asEditable),
        groups.map(value => value),
        instanceId,
        instanceInitiatedShutdownBehavior.map(value => value.asEditable),
        instanceType.map(value => value.asEditable),
        kernel.map(value => value.asEditable),
        ramdisk.map(value => value.asEditable),
        sriovNetSupport.map(value => value.asEditable),
        userData.map(value => value.asEditable),
        value.map(value => value),
        disableApiStop.map(value => value.asEditable)
      )
    def sourceDestCheck
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def attribute: Optional[zio.aws.ec2.model.InstanceAttributeName]
    def blockDeviceMappings: Optional[
      List[zio.aws.ec2.model.InstanceBlockDeviceMappingSpecification.ReadOnly]
    ]
    def disableApiTermination
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def ebsOptimized: Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def enaSupport: Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def groups: Optional[List[SecurityGroupId]]
    def instanceId: InstanceId
    def instanceInitiatedShutdownBehavior
        : Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def instanceType: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def kernel: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def ramdisk: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def sriovNetSupport: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly]
    def userData: Optional[zio.aws.ec2.model.BlobAttributeValue.ReadOnly]
    def value: Optional[String]
    def disableApiStop
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly]
    def getSourceDestCheck
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("sourceDestCheck", sourceDestCheck)
    def getAttribute
        : ZIO[Any, AwsError, zio.aws.ec2.model.InstanceAttributeName] =
      AwsError.unwrapOptionField("attribute", attribute)
    def getBlockDeviceMappings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceBlockDeviceMappingSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("blockDeviceMappings", blockDeviceMappings)
    def getDisableApiTermination
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("disableApiTermination", disableApiTermination)
    def getEbsOptimized
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("ebsOptimized", ebsOptimized)
    def getEnaSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("enaSupport", enaSupport)
    def getGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("groups", groups)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getInstanceInitiatedShutdownBehavior
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField(
        "instanceInitiatedShutdownBehavior",
        instanceInitiatedShutdownBehavior
      )
    def getInstanceType
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getKernel
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("kernel", kernel)
    def getRamdisk
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("ramdisk", ramdisk)
    def getSriovNetSupport
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("sriovNetSupport", sriovNetSupport)
    def getUserData
        : ZIO[Any, AwsError, zio.aws.ec2.model.BlobAttributeValue.ReadOnly] =
      AwsError.unwrapOptionField("userData", userData)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getDisableApiStop
        : ZIO[Any, AwsError, zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      AwsError.unwrapOptionField("disableApiStop", disableApiStop)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeRequest
  ) extends zio.aws.ec2.model.ModifyInstanceAttributeRequest.ReadOnly {
    override val sourceDestCheck
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceDestCheck())
        .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val attribute: Optional[zio.aws.ec2.model.InstanceAttributeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attribute())
        .map(value => zio.aws.ec2.model.InstanceAttributeName.wrap(value))
    override val blockDeviceMappings: Optional[
      List[zio.aws.ec2.model.InstanceBlockDeviceMappingSpecification.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.blockDeviceMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceBlockDeviceMappingSpecification.wrap(item)
        }.toList
      )
    override val disableApiTermination
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableApiTermination())
        .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val ebsOptimized
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ebsOptimized())
        .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val enaSupport
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enaSupport())
        .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
    override val groups: Optional[List[SecurityGroupId]] = zio.aws.core.internal
      .optionalFromNullable(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val instanceInitiatedShutdownBehavior
        : Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceInitiatedShutdownBehavior())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val instanceType
        : Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val kernel: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kernel())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val ramdisk: Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ramdisk())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val sriovNetSupport
        : Optional[zio.aws.ec2.model.AttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sriovNetSupport())
        .map(value => zio.aws.ec2.model.AttributeValue.wrap(value))
    override val userData
        : Optional[zio.aws.ec2.model.BlobAttributeValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userData())
        .map(value => zio.aws.ec2.model.BlobAttributeValue.wrap(value))
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val disableApiStop
        : Optional[zio.aws.ec2.model.AttributeBooleanValue.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableApiStop())
        .map(value => zio.aws.ec2.model.AttributeBooleanValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeRequest
  ): zio.aws.ec2.model.ModifyInstanceAttributeRequest.ReadOnly = new Wrapper(
    impl
  )
}
