package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyIdFormatRequest(resource: String, useLongIds: Boolean) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyIdFormatRequest = {
    import ModifyIdFormatRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyIdFormatRequest
      .builder()
      .resource(resource: java.lang.String)
      .useLongIds(useLongIds: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyIdFormatRequest.ReadOnly =
    zio.aws.ec2.model.ModifyIdFormatRequest.wrap(buildAwsValue())
}
object ModifyIdFormatRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyIdFormatRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyIdFormatRequest =
      zio.aws.ec2.model.ModifyIdFormatRequest(resource, useLongIds)
    def resource: String
    def useLongIds: Boolean
    def getResource: ZIO[Any, Nothing, String] = ZIO.succeed(resource)
    def getUseLongIds: ZIO[Any, Nothing, Boolean] = ZIO.succeed(useLongIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIdFormatRequest
  ) extends zio.aws.ec2.model.ModifyIdFormatRequest.ReadOnly {
    override val resource: String = impl.resource(): String
    override val useLongIds: Boolean = impl.useLongIds(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyIdFormatRequest
  ): zio.aws.ec2.model.ModifyIdFormatRequest.ReadOnly = new Wrapper(impl)
}
