package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait Igmpv2SupportValue {
  def unwrap: software.amazon.awssdk.services.ec2.model.Igmpv2SupportValue
}
object Igmpv2SupportValue {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.Igmpv2SupportValue
  ): zio.aws.ec2.model.Igmpv2SupportValue = value match {
    case software.amazon.awssdk.services.ec2.model.Igmpv2SupportValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.Igmpv2SupportValue.ENABLE =>
      val r = enable
      r
    case software.amazon.awssdk.services.ec2.model.Igmpv2SupportValue.DISABLE =>
      val r = disable
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.Igmpv2SupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.Igmpv2SupportValue =
      software.amazon.awssdk.services.ec2.model.Igmpv2SupportValue.UNKNOWN_TO_SDK_VERSION
  }
  case object enable extends zio.aws.ec2.model.Igmpv2SupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.Igmpv2SupportValue =
      software.amazon.awssdk.services.ec2.model.Igmpv2SupportValue.ENABLE
  }
  case object disable extends zio.aws.ec2.model.Igmpv2SupportValue {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.Igmpv2SupportValue =
      software.amazon.awssdk.services.ec2.model.Igmpv2SupportValue.DISABLE
  }
}
