package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HostInstance(
    instanceId: Optional[String] = Optional.Absent,
    instanceType: Optional[String] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.HostInstance = {
    import HostInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.HostInstance
      .builder()
      .optionallyWith(instanceId.map(value => value: java.lang.String))(
        _.instanceId
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.HostInstance.ReadOnly =
    zio.aws.ec2.model.HostInstance.wrap(buildAwsValue())
}
object HostInstance {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.HostInstance] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.HostInstance =
      zio.aws.ec2.model.HostInstance(
        instanceId.map(value => value),
        instanceType.map(value => value),
        ownerId.map(value => value)
      )
    def instanceId: Optional[String]
    def instanceType: Optional[String]
    def ownerId: Optional[String]
    def getInstanceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.HostInstance
  ) extends zio.aws.ec2.model.HostInstance.ReadOnly {
    override val instanceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => value: String)
    override val instanceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceType())
      .map(value => value: String)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.HostInstance
  ): zio.aws.ec2.model.HostInstance.ReadOnly = new Wrapper(impl)
}
