package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.CertificateId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetAssociatedEnclaveCertificateIamRolesRequest(
    certificateArn: CertificateId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest = {
    import GetAssociatedEnclaveCertificateIamRolesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest
      .builder()
      .certificateArn(CertificateId.unwrap(certificateArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest.ReadOnly =
    zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest
      .wrap(buildAwsValue())
}
object GetAssociatedEnclaveCertificateIamRolesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest =
      zio.aws.ec2.model
        .GetAssociatedEnclaveCertificateIamRolesRequest(certificateArn)
    def certificateArn: CertificateId
    def getCertificateArn: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest
  ) extends zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest.ReadOnly {
    override val certificateArn: CertificateId =
      zio.aws.ec2.model.primitives.CertificateId(impl.certificateArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest
  ): zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest.ReadOnly =
    new Wrapper(impl)
}
