package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ResourceArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FirewallStatefulRule(
    ruleGroupArn: Optional[ResourceArn] = Optional.Absent,
    sources: Optional[Iterable[String]] = Optional.Absent,
    destinations: Optional[Iterable[String]] = Optional.Absent,
    sourcePorts: Optional[Iterable[zio.aws.ec2.model.PortRange]] =
      Optional.Absent,
    destinationPorts: Optional[Iterable[zio.aws.ec2.model.PortRange]] =
      Optional.Absent,
    protocol: Optional[String] = Optional.Absent,
    ruleAction: Optional[String] = Optional.Absent,
    direction: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FirewallStatefulRule = {
    import FirewallStatefulRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FirewallStatefulRule
      .builder()
      .optionallyWith(
        ruleGroupArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.ruleGroupArn)
      .optionallyWith(
        sources.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.sources)
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.destinations)
      .optionallyWith(
        sourcePorts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourcePorts)
      .optionallyWith(
        destinationPorts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinationPorts)
      .optionallyWith(protocol.map(value => value: java.lang.String))(
        _.protocol
      )
      .optionallyWith(ruleAction.map(value => value: java.lang.String))(
        _.ruleAction
      )
      .optionallyWith(direction.map(value => value: java.lang.String))(
        _.direction
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FirewallStatefulRule.ReadOnly =
    zio.aws.ec2.model.FirewallStatefulRule.wrap(buildAwsValue())
}
object FirewallStatefulRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FirewallStatefulRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FirewallStatefulRule =
      zio.aws.ec2.model.FirewallStatefulRule(
        ruleGroupArn.map(value => value),
        sources.map(value => value),
        destinations.map(value => value),
        sourcePorts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        destinationPorts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        protocol.map(value => value),
        ruleAction.map(value => value),
        direction.map(value => value)
      )
    def ruleGroupArn: Optional[ResourceArn]
    def sources: Optional[List[String]]
    def destinations: Optional[List[String]]
    def sourcePorts: Optional[List[zio.aws.ec2.model.PortRange.ReadOnly]]
    def destinationPorts: Optional[List[zio.aws.ec2.model.PortRange.ReadOnly]]
    def protocol: Optional[String]
    def ruleAction: Optional[String]
    def direction: Optional[String]
    def getRuleGroupArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("ruleGroupArn", ruleGroupArn)
    def getSources: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("sources", sources)
    def getDestinations: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("destinations", destinations)
    def getSourcePorts
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PortRange.ReadOnly]] =
      AwsError.unwrapOptionField("sourcePorts", sourcePorts)
    def getDestinationPorts
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.PortRange.ReadOnly]] =
      AwsError.unwrapOptionField("destinationPorts", destinationPorts)
    def getProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getRuleAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ruleAction", ruleAction)
    def getDirection: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("direction", direction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FirewallStatefulRule
  ) extends zio.aws.ec2.model.FirewallStatefulRule.ReadOnly {
    override val ruleGroupArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleGroupArn())
      .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val sources: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.sources())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val destinations: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.destinations())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val sourcePorts
        : Optional[List[zio.aws.ec2.model.PortRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourcePorts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.PortRange.wrap(item)
          }.toList
        )
    override val destinationPorts
        : Optional[List[zio.aws.ec2.model.PortRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationPorts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.PortRange.wrap(item)
          }.toList
        )
    override val protocol: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => value: String)
    override val ruleAction: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleAction())
      .map(value => value: String)
    override val direction: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.direction())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FirewallStatefulRule
  ): zio.aws.ec2.model.FirewallStatefulRule.ReadOnly = new Wrapper(impl)
}
