package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ExportEnvironment {
  def unwrap: software.amazon.awssdk.services.ec2.model.ExportEnvironment
}
object ExportEnvironment {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ExportEnvironment
  ): zio.aws.ec2.model.ExportEnvironment = value match {
    case software.amazon.awssdk.services.ec2.model.ExportEnvironment.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ExportEnvironment.CITRIX =>
      val r = citrix
      r
    case software.amazon.awssdk.services.ec2.model.ExportEnvironment.VMWARE =>
      val r = vmware
      r
    case software.amazon.awssdk.services.ec2.model.ExportEnvironment.MICROSOFT =>
      val r = microsoft
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ExportEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ExportEnvironment =
      software.amazon.awssdk.services.ec2.model.ExportEnvironment.UNKNOWN_TO_SDK_VERSION
  }
  case object citrix extends zio.aws.ec2.model.ExportEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ExportEnvironment =
      software.amazon.awssdk.services.ec2.model.ExportEnvironment.CITRIX
  }
  case object vmware extends zio.aws.ec2.model.ExportEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ExportEnvironment =
      software.amazon.awssdk.services.ec2.model.ExportEnvironment.VMWARE
  }
  case object microsoft extends zio.aws.ec2.model.ExportEnvironment {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ExportEnvironment =
      software.amazon.awssdk.services.ec2.model.ExportEnvironment.MICROSOFT
  }
}
