package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisableAwsNetworkPerformanceMetricSubscriptionRequest(
    source: Optional[String] = Optional.Absent,
    destination: Optional[String] = Optional.Absent,
    metric: Optional[zio.aws.ec2.model.MetricType] = Optional.Absent,
    statistic: Optional[zio.aws.ec2.model.StatisticType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionRequest = {
    import DisableAwsNetworkPerformanceMetricSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionRequest
      .builder()
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .optionallyWith(destination.map(value => value: java.lang.String))(
        _.destination
      )
      .optionallyWith(metric.map(value => value.unwrap))(_.metric)
      .optionallyWith(statistic.map(value => value.unwrap))(_.statistic)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionRequest.ReadOnly =
    zio.aws.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionRequest
      .wrap(buildAwsValue())
}
object DisableAwsNetworkPerformanceMetricSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionRequest =
      zio.aws.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionRequest(
        source.map(value => value),
        destination.map(value => value),
        metric.map(value => value),
        statistic.map(value => value)
      )
    def source: Optional[String]
    def destination: Optional[String]
    def metric: Optional[zio.aws.ec2.model.MetricType]
    def statistic: Optional[zio.aws.ec2.model.StatisticType]
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
    def getDestination: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destination", destination)
    def getMetric: ZIO[Any, AwsError, zio.aws.ec2.model.MetricType] =
      AwsError.unwrapOptionField("metric", metric)
    def getStatistic: ZIO[Any, AwsError, zio.aws.ec2.model.StatisticType] =
      AwsError.unwrapOptionField("statistic", statistic)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionRequest
  ) extends zio.aws.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionRequest.ReadOnly {
    override val source: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => value: String)
    override val destination: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destination())
      .map(value => value: String)
    override val metric: Optional[zio.aws.ec2.model.MetricType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metric())
        .map(value => zio.aws.ec2.model.MetricType.wrap(value))
    override val statistic: Optional[zio.aws.ec2.model.StatisticType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistic())
        .map(value => zio.aws.ec2.model.StatisticType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionRequest
  ): zio.aws.ec2.model.DisableAwsNetworkPerformanceMetricSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
