package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{VpcId, InstanceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DetachClassicLinkVpcRequest(
    instanceId: InstanceId,
    vpcId: VpcId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcRequest = {
    import DetachClassicLinkVpcRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DetachClassicLinkVpcRequest.ReadOnly =
    zio.aws.ec2.model.DetachClassicLinkVpcRequest.wrap(buildAwsValue())
}
object DetachClassicLinkVpcRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DetachClassicLinkVpcRequest =
      zio.aws.ec2.model.DetachClassicLinkVpcRequest(instanceId, vpcId)
    def instanceId: InstanceId
    def vpcId: VpcId
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcRequest
  ) extends zio.aws.ec2.model.DetachClassicLinkVpcRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DetachClassicLinkVpcRequest
  ): zio.aws.ec2.model.DetachClassicLinkVpcRequest.ReadOnly = new Wrapper(impl)
}
