package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVpcsResponse(
    vpcs: Optional[Iterable[zio.aws.ec2.model.Vpc]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcsResponse = {
    import DescribeVpcsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcsResponse
      .builder()
      .optionallyWith(
        vpcs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcs)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVpcsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVpcsResponse.wrap(buildAwsValue())
}
object DescribeVpcsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpcsResponse =
      zio.aws.ec2.model.DescribeVpcsResponse(
        vpcs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def vpcs: Optional[List[zio.aws.ec2.model.Vpc.ReadOnly]]
    def nextToken: Optional[String]
    def getVpcs: ZIO[Any, AwsError, List[zio.aws.ec2.model.Vpc.ReadOnly]] =
      AwsError.unwrapOptionField("vpcs", vpcs)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcsResponse
  ) extends zio.aws.ec2.model.DescribeVpcsResponse.ReadOnly {
    override val vpcs: Optional[List[zio.aws.ec2.model.Vpc.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Vpc.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcsResponse
  ): zio.aws.ec2.model.DescribeVpcsResponse.ReadOnly = new Wrapper(impl)
}
