package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeImagesResponse(
    images: Optional[Iterable[zio.aws.ec2.model.Image]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeImagesResponse = {
    import DescribeImagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeImagesResponse
      .builder()
      .optionallyWith(
        images.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.images)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeImagesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeImagesResponse.wrap(buildAwsValue())
}
object DescribeImagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeImagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeImagesResponse =
      zio.aws.ec2.model.DescribeImagesResponse(
        images.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def images: Optional[List[zio.aws.ec2.model.Image.ReadOnly]]
    def nextToken: Optional[String]
    def getImages: ZIO[Any, AwsError, List[zio.aws.ec2.model.Image.ReadOnly]] =
      AwsError.unwrapOptionField("images", images)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImagesResponse
  ) extends zio.aws.ec2.model.DescribeImagesResponse.ReadOnly {
    override val images: Optional[List[zio.aws.ec2.model.Image.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.images())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Image.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImagesResponse
  ): zio.aws.ec2.model.DescribeImagesResponse.ReadOnly = new Wrapper(impl)
}
