package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeBundleTasksResponse(
    bundleTasks: Optional[Iterable[zio.aws.ec2.model.BundleTask]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeBundleTasksResponse = {
    import DescribeBundleTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeBundleTasksResponse
      .builder()
      .optionallyWith(
        bundleTasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bundleTasks)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeBundleTasksResponse.ReadOnly =
    zio.aws.ec2.model.DescribeBundleTasksResponse.wrap(buildAwsValue())
}
object DescribeBundleTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeBundleTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeBundleTasksResponse =
      zio.aws.ec2.model.DescribeBundleTasksResponse(
        bundleTasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def bundleTasks: Optional[List[zio.aws.ec2.model.BundleTask.ReadOnly]]
    def getBundleTasks
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.BundleTask.ReadOnly]] =
      AwsError.unwrapOptionField("bundleTasks", bundleTasks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeBundleTasksResponse
  ) extends zio.aws.ec2.model.DescribeBundleTasksResponse.ReadOnly {
    override val bundleTasks
        : Optional[List[zio.aws.ec2.model.BundleTask.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bundleTasks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.BundleTask.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeBundleTasksResponse
  ): zio.aws.ec2.model.DescribeBundleTasksResponse.ReadOnly = new Wrapper(impl)
}
