package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait CurrencyCodeValues {
  def unwrap: software.amazon.awssdk.services.ec2.model.CurrencyCodeValues
}
object CurrencyCodeValues {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.CurrencyCodeValues
  ): zio.aws.ec2.model.CurrencyCodeValues = value match {
    case software.amazon.awssdk.services.ec2.model.CurrencyCodeValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.CurrencyCodeValues.USD =>
      val r = USD
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.CurrencyCodeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CurrencyCodeValues =
      software.amazon.awssdk.services.ec2.model.CurrencyCodeValues.UNKNOWN_TO_SDK_VERSION
  }
  case object USD extends zio.aws.ec2.model.CurrencyCodeValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.CurrencyCodeValues =
      software.amazon.awssdk.services.ec2.model.CurrencyCodeValues.USD
  }
}
