package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AttachVerifiedAccessTrustProviderResponse(
    verifiedAccessTrustProvider: Optional[
      zio.aws.ec2.model.VerifiedAccessTrustProvider
    ] = Optional.Absent,
    verifiedAccessInstance: Optional[zio.aws.ec2.model.VerifiedAccessInstance] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderResponse = {
    import AttachVerifiedAccessTrustProviderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderResponse
      .builder()
      .optionallyWith(
        verifiedAccessTrustProvider.map(value => value.buildAwsValue())
      )(_.verifiedAccessTrustProvider)
      .optionallyWith(
        verifiedAccessInstance.map(value => value.buildAwsValue())
      )(_.verifiedAccessInstance)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.AttachVerifiedAccessTrustProviderResponse.ReadOnly =
    zio.aws.ec2.model.AttachVerifiedAccessTrustProviderResponse
      .wrap(buildAwsValue())
}
object AttachVerifiedAccessTrustProviderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.AttachVerifiedAccessTrustProviderResponse =
      zio.aws.ec2.model.AttachVerifiedAccessTrustProviderResponse(
        verifiedAccessTrustProvider.map(value => value.asEditable),
        verifiedAccessInstance.map(value => value.asEditable)
      )
    def verifiedAccessTrustProvider
        : Optional[zio.aws.ec2.model.VerifiedAccessTrustProvider.ReadOnly]
    def verifiedAccessInstance
        : Optional[zio.aws.ec2.model.VerifiedAccessInstance.ReadOnly]
    def getVerifiedAccessTrustProvider: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessTrustProvider.ReadOnly
    ] = AwsError.unwrapOptionField(
      "verifiedAccessTrustProvider",
      verifiedAccessTrustProvider
    )
    def getVerifiedAccessInstance: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessInstance.ReadOnly
    ] = AwsError.unwrapOptionField(
      "verifiedAccessInstance",
      verifiedAccessInstance
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderResponse
  ) extends zio.aws.ec2.model.AttachVerifiedAccessTrustProviderResponse.ReadOnly {
    override val verifiedAccessTrustProvider
        : Optional[zio.aws.ec2.model.VerifiedAccessTrustProvider.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessTrustProvider())
        .map(value => zio.aws.ec2.model.VerifiedAccessTrustProvider.wrap(value))
    override val verifiedAccessInstance
        : Optional[zio.aws.ec2.model.VerifiedAccessInstance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessInstance())
        .map(value => zio.aws.ec2.model.VerifiedAccessInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AttachVerifiedAccessTrustProviderResponse
  ): zio.aws.ec2.model.AttachVerifiedAccessTrustProviderResponse.ReadOnly =
    new Wrapper(impl)
}
