package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AssignIpv6AddressesResponse(
    assignedIpv6Addresses: Optional[Iterable[String]] = Optional.Absent,
    assignedIpv6Prefixes: Optional[Iterable[String]] = Optional.Absent,
    networkInterfaceId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesResponse = {
    import AssignIpv6AddressesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesResponse
      .builder()
      .optionallyWith(
        assignedIpv6Addresses.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.assignedIpv6Addresses)
      .optionallyWith(
        assignedIpv6Prefixes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.assignedIpv6Prefixes)
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AssignIpv6AddressesResponse.ReadOnly =
    zio.aws.ec2.model.AssignIpv6AddressesResponse.wrap(buildAwsValue())
}
object AssignIpv6AddressesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AssignIpv6AddressesResponse =
      zio.aws.ec2.model.AssignIpv6AddressesResponse(
        assignedIpv6Addresses.map(value => value),
        assignedIpv6Prefixes.map(value => value),
        networkInterfaceId.map(value => value)
      )
    def assignedIpv6Addresses: Optional[List[String]]
    def assignedIpv6Prefixes: Optional[List[String]]
    def networkInterfaceId: Optional[String]
    def getAssignedIpv6Addresses: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("assignedIpv6Addresses", assignedIpv6Addresses)
    def getAssignedIpv6Prefixes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("assignedIpv6Prefixes", assignedIpv6Prefixes)
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesResponse
  ) extends zio.aws.ec2.model.AssignIpv6AddressesResponse.ReadOnly {
    override val assignedIpv6Addresses: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assignedIpv6Addresses())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val assignedIpv6Prefixes: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assignedIpv6Prefixes())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val networkInterfaceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaceId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AssignIpv6AddressesResponse
  ): zio.aws.ec2.model.AssignIpv6AddressesResponse.ReadOnly = new Wrapper(impl)
}
