package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait VpcAttributeName {
  def unwrap: software.amazon.awssdk.services.ec2.model.VpcAttributeName
}
object VpcAttributeName {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.VpcAttributeName
  ): zio.aws.ec2.model.VpcAttributeName = value match {
    case software.amazon.awssdk.services.ec2.model.VpcAttributeName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.VpcAttributeName.ENABLE_DNS_SUPPORT =>
      val r = enableDnsSupport
      r
    case software.amazon.awssdk.services.ec2.model.VpcAttributeName.ENABLE_DNS_HOSTNAMES =>
      val r = enableDnsHostnames
      r
    case software.amazon.awssdk.services.ec2.model.VpcAttributeName.ENABLE_NETWORK_ADDRESS_USAGE_METRICS =>
      val r = enableNetworkAddressUsageMetrics
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.VpcAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpcAttributeName =
      software.amazon.awssdk.services.ec2.model.VpcAttributeName.UNKNOWN_TO_SDK_VERSION
  }
  case object enableDnsSupport extends zio.aws.ec2.model.VpcAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpcAttributeName =
      software.amazon.awssdk.services.ec2.model.VpcAttributeName.ENABLE_DNS_SUPPORT
  }
  case object enableDnsHostnames extends zio.aws.ec2.model.VpcAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpcAttributeName =
      software.amazon.awssdk.services.ec2.model.VpcAttributeName.ENABLE_DNS_HOSTNAMES
  }
  case object enableNetworkAddressUsageMetrics
      extends zio.aws.ec2.model.VpcAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.VpcAttributeName =
      software.amazon.awssdk.services.ec2.model.VpcAttributeName.ENABLE_NETWORK_ADDRESS_USAGE_METRICS
  }
}
