package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifiedAccessLogCloudWatchLogsDestinationOptions(
    enabled: Boolean,
    logGroup: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VerifiedAccessLogCloudWatchLogsDestinationOptions = {
    import VerifiedAccessLogCloudWatchLogsDestinationOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VerifiedAccessLogCloudWatchLogsDestinationOptions
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(logGroup.map(value => value: java.lang.String))(
        _.logGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestinationOptions.ReadOnly =
    zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestinationOptions
      .wrap(buildAwsValue())
}
object VerifiedAccessLogCloudWatchLogsDestinationOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VerifiedAccessLogCloudWatchLogsDestinationOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestinationOptions =
      zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestinationOptions(
        enabled,
        logGroup.map(value => value)
      )
    def enabled: Boolean
    def logGroup: Optional[String]
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getLogGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("logGroup", logGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessLogCloudWatchLogsDestinationOptions
  ) extends zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestinationOptions.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val logGroup: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.logGroup())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessLogCloudWatchLogsDestinationOptions
  ): zio.aws.ec2.model.VerifiedAccessLogCloudWatchLogsDestinationOptions.ReadOnly =
    new Wrapper(impl)
}
