package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifiedAccessInstanceLoggingConfiguration(
    verifiedAccessInstanceId: Optional[String] = Optional.Absent,
    accessLogs: Optional[zio.aws.ec2.model.VerifiedAccessLogs] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceLoggingConfiguration = {
    import VerifiedAccessInstanceLoggingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceLoggingConfiguration
      .builder()
      .optionallyWith(
        verifiedAccessInstanceId.map(value => value: java.lang.String)
      )(_.verifiedAccessInstanceId)
      .optionallyWith(accessLogs.map(value => value.buildAwsValue()))(
        _.accessLogs
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.VerifiedAccessInstanceLoggingConfiguration.ReadOnly =
    zio.aws.ec2.model.VerifiedAccessInstanceLoggingConfiguration
      .wrap(buildAwsValue())
}
object VerifiedAccessInstanceLoggingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceLoggingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.VerifiedAccessInstanceLoggingConfiguration =
      zio.aws.ec2.model.VerifiedAccessInstanceLoggingConfiguration(
        verifiedAccessInstanceId.map(value => value),
        accessLogs.map(value => value.asEditable)
      )
    def verifiedAccessInstanceId: Optional[String]
    def accessLogs: Optional[zio.aws.ec2.model.VerifiedAccessLogs.ReadOnly]
    def getVerifiedAccessInstanceId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("verifiedAccessInstanceId", verifiedAccessInstanceId)
    def getAccessLogs
        : ZIO[Any, AwsError, zio.aws.ec2.model.VerifiedAccessLogs.ReadOnly] =
      AwsError.unwrapOptionField("accessLogs", accessLogs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceLoggingConfiguration
  ) extends zio.aws.ec2.model.VerifiedAccessInstanceLoggingConfiguration.ReadOnly {
    override val verifiedAccessInstanceId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessInstanceId())
        .map(value => value: String)
    override val accessLogs
        : Optional[zio.aws.ec2.model.VerifiedAccessLogs.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessLogs())
        .map(value => zio.aws.ec2.model.VerifiedAccessLogs.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessInstanceLoggingConfiguration
  ): zio.aws.ec2.model.VerifiedAccessInstanceLoggingConfiguration.ReadOnly =
    new Wrapper(impl)
}
