package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayPolicyRule(
    sourceCidrBlock: Optional[String] = Optional.Absent,
    sourcePortRange: Optional[String] = Optional.Absent,
    destinationCidrBlock: Optional[String] = Optional.Absent,
    destinationPortRange: Optional[String] = Optional.Absent,
    protocol: Optional[String] = Optional.Absent,
    metaData: Optional[zio.aws.ec2.model.TransitGatewayPolicyRuleMetaData] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyRule = {
    import TransitGatewayPolicyRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyRule
      .builder()
      .optionallyWith(sourceCidrBlock.map(value => value: java.lang.String))(
        _.sourceCidrBlock
      )
      .optionallyWith(sourcePortRange.map(value => value: java.lang.String))(
        _.sourcePortRange
      )
      .optionallyWith(
        destinationCidrBlock.map(value => value: java.lang.String)
      )(_.destinationCidrBlock)
      .optionallyWith(
        destinationPortRange.map(value => value: java.lang.String)
      )(_.destinationPortRange)
      .optionallyWith(protocol.map(value => value: java.lang.String))(
        _.protocol
      )
      .optionallyWith(metaData.map(value => value.buildAwsValue()))(_.metaData)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayPolicyRule.ReadOnly =
    zio.aws.ec2.model.TransitGatewayPolicyRule.wrap(buildAwsValue())
}
object TransitGatewayPolicyRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayPolicyRule =
      zio.aws.ec2.model.TransitGatewayPolicyRule(
        sourceCidrBlock.map(value => value),
        sourcePortRange.map(value => value),
        destinationCidrBlock.map(value => value),
        destinationPortRange.map(value => value),
        protocol.map(value => value),
        metaData.map(value => value.asEditable)
      )
    def sourceCidrBlock: Optional[String]
    def sourcePortRange: Optional[String]
    def destinationCidrBlock: Optional[String]
    def destinationPortRange: Optional[String]
    def protocol: Optional[String]
    def metaData
        : Optional[zio.aws.ec2.model.TransitGatewayPolicyRuleMetaData.ReadOnly]
    def getSourceCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceCidrBlock", sourceCidrBlock)
    def getSourcePortRange: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourcePortRange", sourcePortRange)
    def getDestinationCidrBlock: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
    def getDestinationPortRange: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("destinationPortRange", destinationPortRange)
    def getProtocol: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getMetaData: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayPolicyRuleMetaData.ReadOnly
    ] = AwsError.unwrapOptionField("metaData", metaData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyRule
  ) extends zio.aws.ec2.model.TransitGatewayPolicyRule.ReadOnly {
    override val sourceCidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceCidrBlock())
      .map(value => value: String)
    override val sourcePortRange: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourcePortRange())
      .map(value => value: String)
    override val destinationCidrBlock: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationCidrBlock())
      .map(value => value: String)
    override val destinationPortRange: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationPortRange())
      .map(value => value: String)
    override val protocol: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => value: String)
    override val metaData: Optional[
      zio.aws.ec2.model.TransitGatewayPolicyRuleMetaData.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metaData())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayPolicyRuleMetaData.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyRule
  ): zio.aws.ec2.model.TransitGatewayPolicyRule.ReadOnly = new Wrapper(impl)
}
