package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TrafficMirrorSession(
    trafficMirrorSessionId: Optional[String] = Optional.Absent,
    trafficMirrorTargetId: Optional[String] = Optional.Absent,
    trafficMirrorFilterId: Optional[String] = Optional.Absent,
    networkInterfaceId: Optional[String] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    packetLength: Optional[Integer] = Optional.Absent,
    sessionNumber: Optional[Integer] = Optional.Absent,
    virtualNetworkId: Optional[Integer] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TrafficMirrorSession = {
    import TrafficMirrorSession.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TrafficMirrorSession
      .builder()
      .optionallyWith(
        trafficMirrorSessionId.map(value => value: java.lang.String)
      )(_.trafficMirrorSessionId)
      .optionallyWith(
        trafficMirrorTargetId.map(value => value: java.lang.String)
      )(_.trafficMirrorTargetId)
      .optionallyWith(
        trafficMirrorFilterId.map(value => value: java.lang.String)
      )(_.trafficMirrorFilterId)
      .optionallyWith(networkInterfaceId.map(value => value: java.lang.String))(
        _.networkInterfaceId
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(packetLength.map(value => value: java.lang.Integer))(
        _.packetLength
      )
      .optionallyWith(sessionNumber.map(value => value: java.lang.Integer))(
        _.sessionNumber
      )
      .optionallyWith(virtualNetworkId.map(value => value: java.lang.Integer))(
        _.virtualNetworkId
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TrafficMirrorSession.ReadOnly =
    zio.aws.ec2.model.TrafficMirrorSession.wrap(buildAwsValue())
}
object TrafficMirrorSession {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TrafficMirrorSession
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TrafficMirrorSession =
      zio.aws.ec2.model.TrafficMirrorSession(
        trafficMirrorSessionId.map(value => value),
        trafficMirrorTargetId.map(value => value),
        trafficMirrorFilterId.map(value => value),
        networkInterfaceId.map(value => value),
        ownerId.map(value => value),
        packetLength.map(value => value),
        sessionNumber.map(value => value),
        virtualNetworkId.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def trafficMirrorSessionId: Optional[String]
    def trafficMirrorTargetId: Optional[String]
    def trafficMirrorFilterId: Optional[String]
    def networkInterfaceId: Optional[String]
    def ownerId: Optional[String]
    def packetLength: Optional[Integer]
    def sessionNumber: Optional[Integer]
    def virtualNetworkId: Optional[Integer]
    def description: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getTrafficMirrorSessionId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("trafficMirrorSessionId", trafficMirrorSessionId)
    def getTrafficMirrorTargetId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("trafficMirrorTargetId", trafficMirrorTargetId)
    def getTrafficMirrorFilterId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("trafficMirrorFilterId", trafficMirrorFilterId)
    def getNetworkInterfaceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getPacketLength: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("packetLength", packetLength)
    def getSessionNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sessionNumber", sessionNumber)
    def getVirtualNetworkId: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("virtualNetworkId", virtualNetworkId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TrafficMirrorSession
  ) extends zio.aws.ec2.model.TrafficMirrorSession.ReadOnly {
    override val trafficMirrorSessionId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficMirrorSessionId())
        .map(value => value: String)
    override val trafficMirrorTargetId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.trafficMirrorTargetId())
      .map(value => value: String)
    override val trafficMirrorFilterId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.trafficMirrorFilterId())
      .map(value => value: String)
    override val networkInterfaceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaceId())
      .map(value => value: String)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val packetLength: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.packetLength())
      .map(value => value: Integer)
    override val sessionNumber: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionNumber())
      .map(value => value: Integer)
    override val virtualNetworkId: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.virtualNetworkId())
      .map(value => value: Integer)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TrafficMirrorSession
  ): zio.aws.ec2.model.TrafficMirrorSession.ReadOnly = new Wrapper(impl)
}
