package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SnapshotTaskDetail(
    description: Optional[String] = Optional.Absent,
    diskImageSize: Optional[Double] = Optional.Absent,
    encrypted: Optional[Boolean] = Optional.Absent,
    format: Optional[String] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    progress: Optional[String] = Optional.Absent,
    snapshotId: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    url: Optional[String] = Optional.Absent,
    userBucket: Optional[zio.aws.ec2.model.UserBucketDetails] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SnapshotTaskDetail = {
    import SnapshotTaskDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SnapshotTaskDetail
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(diskImageSize.map(value => value: java.lang.Double))(
        _.diskImageSize
      )
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(format.map(value => value: java.lang.String))(_.format)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(progress.map(value => value: java.lang.String))(
        _.progress
      )
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .optionallyWith(userBucket.map(value => value.buildAwsValue()))(
        _.userBucket
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SnapshotTaskDetail.ReadOnly =
    zio.aws.ec2.model.SnapshotTaskDetail.wrap(buildAwsValue())
}
object SnapshotTaskDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SnapshotTaskDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SnapshotTaskDetail =
      zio.aws.ec2.model.SnapshotTaskDetail(
        description.map(value => value),
        diskImageSize.map(value => value),
        encrypted.map(value => value),
        format.map(value => value),
        kmsKeyId.map(value => value),
        progress.map(value => value),
        snapshotId.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        url.map(value => value),
        userBucket.map(value => value.asEditable)
      )
    def description: Optional[String]
    def diskImageSize: Optional[Double]
    def encrypted: Optional[Boolean]
    def format: Optional[String]
    def kmsKeyId: Optional[String]
    def progress: Optional[String]
    def snapshotId: Optional[String]
    def status: Optional[String]
    def statusMessage: Optional[String]
    def url: Optional[String]
    def userBucket: Optional[zio.aws.ec2.model.UserBucketDetails.ReadOnly]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDiskImageSize: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("diskImageSize", diskImageSize)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getFormat: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("format", format)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("progress", progress)
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("url", url)
    def getUserBucket
        : ZIO[Any, AwsError, zio.aws.ec2.model.UserBucketDetails.ReadOnly] =
      AwsError.unwrapOptionField("userBucket", userBucket)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SnapshotTaskDetail
  ) extends zio.aws.ec2.model.SnapshotTaskDetail.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val diskImageSize: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.diskImageSize())
      .map(value => value: Double)
    override val encrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: Boolean)
    override val format: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.format())
      .map(value => value: String)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val progress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.progress())
      .map(value => value: String)
    override val snapshotId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val url: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => value: String)
    override val userBucket
        : Optional[zio.aws.ec2.model.UserBucketDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userBucket())
        .map(value => zio.aws.ec2.model.UserBucketDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SnapshotTaskDetail
  ): zio.aws.ec2.model.SnapshotTaskDetail.ReadOnly = new Wrapper(impl)
}
