package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3ObjectTag(
    key: Optional[String] = Optional.Absent,
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ec2.model.S3ObjectTag = {
    import S3ObjectTag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.S3ObjectTag
      .builder()
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.S3ObjectTag.ReadOnly =
    zio.aws.ec2.model.S3ObjectTag.wrap(buildAwsValue())
}
object S3ObjectTag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.S3ObjectTag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.S3ObjectTag = zio.aws.ec2.model
      .S3ObjectTag(key.map(value => value), value.map(value => value))
    def key: Optional[String]
    def value: Optional[String]
    def getKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.S3ObjectTag
  ) extends zio.aws.ec2.model.S3ObjectTag.ReadOnly {
    override val key: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => value: String)
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.S3ObjectTag
  ): zio.aws.ec2.model.S3ObjectTag.ReadOnly = new Wrapper(impl)
}
