package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait RouteOrigin {
  def unwrap: software.amazon.awssdk.services.ec2.model.RouteOrigin
}
object RouteOrigin {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.RouteOrigin
  ): zio.aws.ec2.model.RouteOrigin = value match {
    case software.amazon.awssdk.services.ec2.model.RouteOrigin.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.RouteOrigin.CREATE_ROUTE_TABLE =>
      val r = CreateRouteTable
      r
    case software.amazon.awssdk.services.ec2.model.RouteOrigin.CREATE_ROUTE =>
      val r = CreateRoute
      r
    case software.amazon.awssdk.services.ec2.model.RouteOrigin.ENABLE_VGW_ROUTE_PROPAGATION =>
      val r = EnableVgwRoutePropagation
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.RouteOrigin {
    override def unwrap: software.amazon.awssdk.services.ec2.model.RouteOrigin =
      software.amazon.awssdk.services.ec2.model.RouteOrigin.UNKNOWN_TO_SDK_VERSION
  }
  case object CreateRouteTable extends zio.aws.ec2.model.RouteOrigin {
    override def unwrap: software.amazon.awssdk.services.ec2.model.RouteOrigin =
      software.amazon.awssdk.services.ec2.model.RouteOrigin.CREATE_ROUTE_TABLE
  }
  case object CreateRoute extends zio.aws.ec2.model.RouteOrigin {
    override def unwrap: software.amazon.awssdk.services.ec2.model.RouteOrigin =
      software.amazon.awssdk.services.ec2.model.RouteOrigin.CREATE_ROUTE
  }
  case object EnableVgwRoutePropagation extends zio.aws.ec2.model.RouteOrigin {
    override def unwrap: software.amazon.awssdk.services.ec2.model.RouteOrigin =
      software.amazon.awssdk.services.ec2.model.RouteOrigin.ENABLE_VGW_ROUTE_PROPAGATION
  }
}
