package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterTransitGatewayMulticastGroupMembersResponse(
    registeredMulticastGroupMembers: Optional[
      zio.aws.ec2.model.TransitGatewayMulticastRegisteredGroupMembers
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse = {
    import RegisterTransitGatewayMulticastGroupMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse
      .builder()
      .optionallyWith(
        registeredMulticastGroupMembers.map(value => value.buildAwsValue())
      )(_.registeredMulticastGroupMembers)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse.ReadOnly =
    zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse
      .wrap(buildAwsValue())
}
object RegisterTransitGatewayMulticastGroupMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse =
      zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse(
        registeredMulticastGroupMembers.map(value => value.asEditable)
      )
    def registeredMulticastGroupMembers: Optional[
      zio.aws.ec2.model.TransitGatewayMulticastRegisteredGroupMembers.ReadOnly
    ]
    def getRegisteredMulticastGroupMembers: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayMulticastRegisteredGroupMembers.ReadOnly
    ] = AwsError.unwrapOptionField(
      "registeredMulticastGroupMembers",
      registeredMulticastGroupMembers
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse
  ) extends zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse.ReadOnly {
    override val registeredMulticastGroupMembers: Optional[
      zio.aws.ec2.model.TransitGatewayMulticastRegisteredGroupMembers.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.registeredMulticastGroupMembers())
      .map(value =>
        zio.aws.ec2.model.TransitGatewayMulticastRegisteredGroupMembers
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse
  ): zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse.ReadOnly =
    new Wrapper(impl)
}
