package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PrivateDnsNameOptionsOnLaunch(
    hostnameType: Optional[zio.aws.ec2.model.HostnameType] = Optional.Absent,
    enableResourceNameDnsARecord: Optional[Boolean] = Optional.Absent,
    enableResourceNameDnsAAAARecord: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.PrivateDnsNameOptionsOnLaunch = {
    import PrivateDnsNameOptionsOnLaunch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.PrivateDnsNameOptionsOnLaunch
      .builder()
      .optionallyWith(hostnameType.map(value => value.unwrap))(_.hostnameType)
      .optionallyWith(
        enableResourceNameDnsARecord.map(value => value: java.lang.Boolean)
      )(_.enableResourceNameDnsARecord)
      .optionallyWith(
        enableResourceNameDnsAAAARecord.map(value => value: java.lang.Boolean)
      )(_.enableResourceNameDnsAAAARecord)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch.ReadOnly =
    zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch.wrap(buildAwsValue())
}
object PrivateDnsNameOptionsOnLaunch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.PrivateDnsNameOptionsOnLaunch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch =
      zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch(
        hostnameType.map(value => value),
        enableResourceNameDnsARecord.map(value => value),
        enableResourceNameDnsAAAARecord.map(value => value)
      )
    def hostnameType: Optional[zio.aws.ec2.model.HostnameType]
    def enableResourceNameDnsARecord: Optional[Boolean]
    def enableResourceNameDnsAAAARecord: Optional[Boolean]
    def getHostnameType: ZIO[Any, AwsError, zio.aws.ec2.model.HostnameType] =
      AwsError.unwrapOptionField("hostnameType", hostnameType)
    def getEnableResourceNameDnsARecord: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableResourceNameDnsARecord",
        enableResourceNameDnsARecord
      )
    def getEnableResourceNameDnsAAAARecord: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "enableResourceNameDnsAAAARecord",
        enableResourceNameDnsAAAARecord
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.PrivateDnsNameOptionsOnLaunch
  ) extends zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch.ReadOnly {
    override val hostnameType: Optional[zio.aws.ec2.model.HostnameType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostnameType())
        .map(value => zio.aws.ec2.model.HostnameType.wrap(value))
    override val enableResourceNameDnsARecord: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableResourceNameDnsARecord())
        .map(value => value: Boolean)
    override val enableResourceNameDnsAAAARecord: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableResourceNameDnsAAAARecord())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.PrivateDnsNameOptionsOnLaunch
  ): zio.aws.ec2.model.PrivateDnsNameOptionsOnLaunch.ReadOnly = new Wrapper(
    impl
  )
}
