package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  VerifiedAccessInstanceId,
  VerifiedAccessGroupId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVerifiedAccessGroupRequest(
    verifiedAccessGroupId: VerifiedAccessGroupId,
    verifiedAccessInstanceId: Optional[VerifiedAccessInstanceId] =
      Optional.Absent,
    description: Optional[String] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupRequest = {
    import ModifyVerifiedAccessGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupRequest
      .builder()
      .verifiedAccessGroupId(
        VerifiedAccessGroupId.unwrap(verifiedAccessGroupId): java.lang.String
      )
      .optionallyWith(
        verifiedAccessInstanceId.map(value =>
          VerifiedAccessInstanceId.unwrap(value): java.lang.String
        )
      )(_.verifiedAccessInstanceId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyVerifiedAccessGroupRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVerifiedAccessGroupRequest.wrap(buildAwsValue())
}
object ModifyVerifiedAccessGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVerifiedAccessGroupRequest =
      zio.aws.ec2.model.ModifyVerifiedAccessGroupRequest(
        verifiedAccessGroupId,
        verifiedAccessInstanceId.map(value => value),
        description.map(value => value),
        clientToken.map(value => value)
      )
    def verifiedAccessGroupId: VerifiedAccessGroupId
    def verifiedAccessInstanceId: Optional[VerifiedAccessInstanceId]
    def description: Optional[String]
    def clientToken: Optional[String]
    def getVerifiedAccessGroupId: ZIO[Any, Nothing, VerifiedAccessGroupId] =
      ZIO.succeed(verifiedAccessGroupId)
    def getVerifiedAccessInstanceId
        : ZIO[Any, AwsError, VerifiedAccessInstanceId] = AwsError
      .unwrapOptionField("verifiedAccessInstanceId", verifiedAccessInstanceId)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupRequest
  ) extends zio.aws.ec2.model.ModifyVerifiedAccessGroupRequest.ReadOnly {
    override val verifiedAccessGroupId: VerifiedAccessGroupId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessGroupId(impl.verifiedAccessGroupId())
    override val verifiedAccessInstanceId: Optional[VerifiedAccessInstanceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessInstanceId())
        .map(value =>
          zio.aws.ec2.model.primitives.VerifiedAccessInstanceId(value)
        )
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessGroupRequest
  ): zio.aws.ec2.model.ModifyVerifiedAccessGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
