package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyTrafficMirrorSessionResponse(
    trafficMirrorSession: Optional[zio.aws.ec2.model.TrafficMirrorSession] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionResponse = {
    import ModifyTrafficMirrorSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionResponse
      .builder()
      .optionallyWith(trafficMirrorSession.map(value => value.buildAwsValue()))(
        _.trafficMirrorSession
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyTrafficMirrorSessionResponse.ReadOnly =
    zio.aws.ec2.model.ModifyTrafficMirrorSessionResponse.wrap(buildAwsValue())
}
object ModifyTrafficMirrorSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyTrafficMirrorSessionResponse =
      zio.aws.ec2.model.ModifyTrafficMirrorSessionResponse(
        trafficMirrorSession.map(value => value.asEditable)
      )
    def trafficMirrorSession
        : Optional[zio.aws.ec2.model.TrafficMirrorSession.ReadOnly]
    def getTrafficMirrorSession
        : ZIO[Any, AwsError, zio.aws.ec2.model.TrafficMirrorSession.ReadOnly] =
      AwsError.unwrapOptionField("trafficMirrorSession", trafficMirrorSession)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionResponse
  ) extends zio.aws.ec2.model.ModifyTrafficMirrorSessionResponse.ReadOnly {
    override val trafficMirrorSession
        : Optional[zio.aws.ec2.model.TrafficMirrorSession.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficMirrorSession())
        .map(value => zio.aws.ec2.model.TrafficMirrorSession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTrafficMirrorSessionResponse
  ): zio.aws.ec2.model.ModifyTrafficMirrorSessionResponse.ReadOnly =
    new Wrapper(impl)
}
